/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes.commands;

import es.kikisito.nfcnotes.Main;
import es.kikisito.nfcnotes.UpdateChecker;
import es.kikisito.nfcnotes.enums.NFCConfig;
import es.kikisito.nfcnotes.enums.NFCMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class NFCNotes
implements CommandExecutor,
TabCompleter {
    private final Main plugin;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public NFCNotes(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        Audience audience = this.plugin.getAdventure().sender(sender);
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("reload") && sender.hasPermission("nfcnotes.staff.reload")) {
                this.plugin.reloadPlugin();
                audience.sendMessage(NFCMessages.STAFF_PLUGIN_RELOADED.getString());
            } else if ((args[0].equalsIgnoreCase("check") || args[0].equalsIgnoreCase("update")) && sender.hasPermission("nfcnotes.staff.check-updates")) {
                new UpdateChecker(this.plugin).getVersion(version -> {
                    if (!this.plugin.getDescription().getVersion().equals(version)) {
                        audience.sendMessage(NFCMessages.getClickableComponent("open_url", "https://github.com/Kikisito/NFCNotes/releases/", NFCMessages.UPDATES_UPDATE_AVAILABLE.getString("{version}", (String)version)));
                    } else {
                        audience.sendMessage(NFCMessages.UPDATES_NO_UPDATES.getString());
                    }
                });
            } else {
                audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
            }
        } else if (NFCConfig.SHOW_PLUGIN_INFO.getBoolean()) {
            audience.sendMessage((Component)this.mm.deserialize("<dark_gray>[</dark_gray><gold>NFCNotes</gold><dark_gray>]</dark_gray> <gray>Developed by</gray> <gold>Kikisito</gold>"));
            audience.sendMessage((Component)this.mm.deserialize("<dark_gray>[</dark_gray><gold>NFCNotes</gold><dark_gray>]</dark_gray> <gray>Version</gray> <gold>" + this.plugin.getDescription().getVersion() + "</gold>"));
            audience.sendMessage((Component)this.mm.deserialize("<dark_gray>[</dark_gray><gold>NFCNotes</gold><dark_gray>]</dark_gray> <gray>Get more information at</gray>"));
            audience.sendMessage((Component)this.mm.deserialize("<dark_gray>[</dark_gray><gold>NFCNotes</gold><dark_gray>]</dark_gray> <gold>https://github.com/Kikisito/NFCNotes</gold>"));
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        List<String> options = Arrays.asList("reload", "check", "update");
        ArrayList<String> tab = new ArrayList<String>();
        for (String s : options) {
            if (!s.startsWith(args[0])) continue;
            tab.add(s);
        }
        return tab;
    }
}

