/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes.commands;

import es.kikisito.nfcnotes.Main;
import es.kikisito.nfcnotes.NFCNote;
import es.kikisito.nfcnotes.enums.ActionMethod;
import es.kikisito.nfcnotes.enums.NFCConfig;
import es.kikisito.nfcnotes.enums.NFCMessages;
import es.kikisito.nfcnotes.enums.SoundConversor;
import es.kikisito.nfcnotes.events.DepositEvent;
import es.kikisito.nfcnotes.utils.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Deposit
implements CommandExecutor,
TabCompleter {
    private final Main plugin;
    private final DecimalFormat decimalFormat = Utils.getDecimalFormat();

    public Deposit(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        Audience playerAudience;
        Audience audience = this.plugin.getAdventure().sender(sender);
        double value = 0.0;
        if (!(sender instanceof Player)) {
            audience.sendMessage(NFCMessages.ONLY_PLAYERS.getString());
            return false;
        }
        Player p = (Player)sender;
        if (NFCConfig.DISABLED_WORLDS.getStrings().contains(p.getWorld().getName()) && !p.hasPermission("nfcnotes.staff.deposit.bypass.disabled-world")) {
            sender.sendMessage(NFCMessages.DISABLED_WORLD.getString());
            return false;
        }
        switch (args.length) {
            case 0: {
                if (!p.hasPermission("nfcnotes.deposit.command.one")) break;
                if (NFCConfig.MODULES_DEPOSIT_COMMAND.getBoolean()) {
                    if (NFCNote.isNFCNote(this.plugin, p.getInventory().getItemInMainHand())) {
                        NFCNote nfcNote = new NFCNote(this.plugin, p.getInventory().getItemInMainHand());
                        value = nfcNote.getValue();
                        this.depositMoney(nfcNote, p, 1, value);
                        break;
                    }
                    audience.sendMessage(NFCMessages.NOT_A_NOTE.getString());
                    break;
                }
                audience.sendMessage(NFCMessages.MODULE_DISABLED.getString());
                break;
            }
            case 1: {
                if (args[0].equals("all")) {
                    if (NFCConfig.MODULES_DEPOSIT_ONE.getBoolean()) {
                        if (p.hasPermission("nfcnotes.deposit.command.all")) {
                            ArrayList<ItemStack> notes = new ArrayList<ItemStack>();
                            for (ItemStack i : p.getInventory()) {
                                if (!NFCNote.isNFCNote(this.plugin, i)) continue;
                                NFCNote nfcNote = new NFCNote(this.plugin, i);
                                double amount = nfcNote.getValue() * (double)i.getAmount();
                                value += amount;
                                notes.add(i);
                            }
                            if (value == 0.0) {
                                audience.sendMessage(NFCMessages.NO_NOTES_FOUND.getString());
                                return false;
                            }
                            DepositEvent depositEvent = new DepositEvent(p, value, ActionMethod.COMMAND_ALL);
                            this.plugin.getServer().getPluginManager().callEvent((Event)depositEvent);
                            if (depositEvent.isCancelled()) break;
                            Player player = depositEvent.getPlayer();
                            playerAudience = this.plugin.getAdventure().player(player);
                            double money = depositEvent.getMoney();
                            String formattedMoney = this.decimalFormat.format(money);
                            if (Utils.depositSuccessful(this.plugin, player, money)) {
                                for (ItemStack i : notes) {
                                    i.setAmount(0);
                                }
                                playerAudience.sendMessage(NFCMessages.MASSDEPOSIT_SUCCESSFUL.getString("{money}", formattedMoney));
                                Deposit.playRedeemSound(player);
                                break;
                            }
                            playerAudience.sendMessage(NFCMessages.UNEXPECTED_ERROR.getString());
                            break;
                        }
                        audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                        break;
                    }
                    audience.sendMessage(NFCMessages.MODULE_DISABLED.getString());
                    break;
                }
                if (args[0].equals("stack")) {
                    if (NFCConfig.MODULES_DEPOSIT_STACK.getBoolean()) {
                        if (p.hasPermission("nfcnotes.deposit.command.stack")) {
                            if (NFCNote.isNFCNote(this.plugin, p.getInventory().getItemInMainHand())) {
                                NFCNote nfcNote = new NFCNote(this.plugin, p.getInventory().getItemInMainHand());
                                value = nfcNote.getValue();
                                this.depositMoney(nfcNote, p, nfcNote.getItemStack().getAmount(), value);
                                break;
                            }
                            audience.sendMessage(NFCMessages.NOT_A_NOTE.getString());
                            break;
                        }
                        audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                        break;
                    }
                    audience.sendMessage(NFCMessages.MODULE_DISABLED.getString());
                    break;
                }
                if (Utils.isInteger(args[0])) {
                    if (NFCConfig.MODULES_DEPOSIT_MULTIPLE.getBoolean()) {
                        if (p.hasPermission("nfcnotes.deposit.command.multiple")) {
                            if (NFCNote.isNFCNote(this.plugin, p.getInventory().getItemInMainHand())) {
                                int amount = Integer.parseInt(args[0]);
                                NFCNote nfcNote = new NFCNote(this.plugin, p.getInventory().getItemInMainHand());
                                if (nfcNote.getItemStack().getAmount() >= amount) {
                                    value = nfcNote.getValue();
                                    this.depositMoney(nfcNote, p, amount, value);
                                    break;
                                }
                                audience.sendMessage(NFCMessages.INSUFFICIENT_NOTES.getString());
                                break;
                            }
                            audience.sendMessage(NFCMessages.NOT_A_NOTE.getString());
                            break;
                        }
                        audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                        break;
                    }
                    audience.sendMessage(NFCMessages.MODULE_DISABLED.getString());
                    break;
                }
            }
            default: {
                audience.sendMessage(NFCMessages.DEPOSIT_USAGE.getString());
            }
        }
        if (value >= (double)NFCConfig.WARN_VALUE_LIMIT.getInt() && NFCConfig.MODULES_WARN_STAFF.getBoolean()) {
            String formattedMoney = this.decimalFormat.format(value);
            for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
                playerAudience = this.plugin.getAdventure().player(pl);
                if (!pl.hasPermission("nfcnotes.staff.warn") || p == pl) continue;
                playerAudience.sendMessage(NFCMessages.STAFF_WARN_DEPOSIT.getString("{player}", p.getName(), "{money}", formattedMoney));
                this.plugin.getLogger().info(NFCMessages.STAFF_WARN_DEPOSIT.getLegacyString("{player}", p.getName(), "{money}", formattedMoney));
            }
        }
        return false;
    }

    public void depositMoney(NFCNote nfcNote, Player p, int amount, double value) {
        DepositEvent depositEvent = new DepositEvent(p, value * (double)amount, ActionMethod.COMMAND);
        if (!depositEvent.isCancelled()) {
            this.plugin.getServer().getPluginManager().callEvent((Event)depositEvent);
            Player player = depositEvent.getPlayer();
            Audience playerAudience = this.plugin.getAdventure().player(player);
            value = depositEvent.getMoney();
            String formattedMoney = this.decimalFormat.format(value);
            if (Utils.depositSuccessful(this.plugin, player, value)) {
                playerAudience.sendMessage(NFCMessages.DEPOSIT_SUCCESSFUL.getString("{money}", formattedMoney));
                Deposit.playRedeemSound(player);
                nfcNote.getItemStack().setAmount(nfcNote.getItemStack().getAmount() - amount);
            } else {
                Audience senderAudience = this.plugin.getAdventure().player(p);
                senderAudience.sendMessage(NFCMessages.UNEXPECTED_ERROR.getString());
            }
        }
    }

    public static void playRedeemSound(Player player) {
        if (NFCConfig.REDEEM_SOUND_ENABLED.getBoolean()) {
            String soundRaw = NFCConfig.REDEEM_SOUND.getString();
            int configVersion = NFCConfig.VERSION.getInt();
            NamespacedKey soundKey = configVersion < 13 ? NamespacedKey.minecraft((String)SoundConversor.valueOf(soundRaw).getKey()) : NamespacedKey.minecraft((String)soundRaw);
            Sound sound = (Sound)Registry.SOUNDS.get(soundKey);
            SoundCategory soundCategory = SoundCategory.valueOf((String)NFCConfig.REDEEM_SOUND_CATEGORY.getString());
            float volume = NFCConfig.REDEEM_SOUND_VOLUME.getDouble().floatValue();
            float pitch = NFCConfig.REDEEM_SOUND_PITCH.getDouble().floatValue();
            player.playSound(player.getLocation(), sound, soundCategory, volume, pitch);
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        List<String> options = Arrays.asList("all", "stack");
        ArrayList<String> tab = new ArrayList<String>();
        for (String s : options) {
            if (!s.startsWith(args[0])) continue;
            tab.add(s);
        }
        return tab;
    }
}

