/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes.commands;

import es.kikisito.nfcnotes.Main;
import es.kikisito.nfcnotes.NFCNote;
import es.kikisito.nfcnotes.enums.NFCConfig;
import es.kikisito.nfcnotes.enums.NFCMessages;
import es.kikisito.nfcnotes.utils.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class CreateNote
implements CommandExecutor,
TabExecutor {
    private final Main plugin;

    public CreateNote(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        Audience audience = this.plugin.getAdventure().sender(sender);
        if (!sender.hasPermission("nfcnotes.staff.createnote")) {
            audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
            return false;
        }
        if (sender instanceof Player && ((Player)sender).getInventory().firstEmpty() == -1) {
            audience.sendMessage(NFCMessages.FULL_INVENTORY.getString());
            return false;
        }
        try {
            switch (args.length) {
                case 1: {
                    if (sender instanceof Player) {
                        Player p = (Player)sender;
                        double money = Double.parseDouble(args[0]);
                        this.createNote(audience, p, money, 1);
                        break;
                    }
                    audience.sendMessage(NFCMessages.ONLY_PLAYERS.getString());
                    break;
                }
                case 2: {
                    if (this.plugin.getServer().getOnlinePlayers().contains(this.plugin.getServer().getPlayer(args[0]))) {
                        Player player = this.plugin.getServer().getPlayer(args[0]);
                        double money = Double.parseDouble(args[1]);
                        this.createNote(audience, player, money, 1);
                        break;
                    }
                    if (sender instanceof Player) {
                        Player p = (Player)sender;
                        double money = Double.parseDouble(args[0]);
                        int amount = Integer.parseInt(args[1]);
                        this.createNote(audience, p, money, amount);
                        break;
                    }
                    audience.sendMessage(NFCMessages.ONLY_PLAYERS.getString());
                    break;
                }
                case 3: {
                    if (this.plugin.getServer().getOnlinePlayers().contains(this.plugin.getServer().getPlayer(args[0]))) {
                        Player player = this.plugin.getServer().getPlayer(args[0]);
                        double money = Double.parseDouble(args[1]);
                        int amount = Integer.parseInt(args[2]);
                        this.createNote(audience, player, money, amount);
                        break;
                    }
                }
                default: {
                    audience.sendMessage(NFCMessages.CREATENOTE_USAGE.getString());
                    break;
                }
            }
        }
        catch (NumberFormatException ex) {
            audience.sendMessage(NFCMessages.INCORRECT_FORMAT.getString());
        }
        return true;
    }

    private void createNote(Audience audience, Player p, Double m, Integer a) {
        if (m <= 0.0) {
            audience.sendMessage(NFCMessages.USE_A_NUMBER_HIGHER_THAN_ZERO.getString());
            return;
        }
        if (m % 1.0 != 0.0 && !NFCConfig.USE_DECIMALS.getBoolean()) {
            audience.sendMessage(NFCMessages.ONLY_INTEGERS.getString());
            return;
        }
        int freeSlots = this.countFreeSlots(p.getInventory());
        if (a > 64 && freeSlots < (int)Math.ceil((double)a.intValue() / 64.0)) {
            audience.sendMessage(NFCMessages.NOT_ENOUGH_SPACE.getString());
            return;
        }
        DecimalFormat decimalFormat = Utils.getDecimalFormat();
        String formattedMoney = decimalFormat.format(m);
        ItemStack paper = NFCNote.createNFCNoteItem(this.plugin, NFCConfig.NOTE_NAME.getMessage(), NFCConfig.NOTE_LORE.getMessages(), NFCConfig.NOTE_MATERIAL.getString(), p.getName(), decimalFormat, m, a);
        p.getInventory().addItem(new ItemStack[]{paper});
        audience.sendMessage(NFCMessages.CREATENOTE_SUCCESSFUL.getString("{money}", formattedMoney));
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        ArrayList<String> tab = new ArrayList<String>();
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            if (!p.getName().startsWith(args[0])) continue;
            tab.add(p.getName());
        }
        return tab;
    }

    private int countFreeSlots(PlayerInventory inventory) {
        int freeSlots = 0;
        for (ItemStack item : inventory.getStorageContents()) {
            if (item != null) continue;
            ++freeSlots;
        }
        return freeSlots;
    }
}

