/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes.commands;

import es.kikisito.nfcnotes.Main;
import es.kikisito.nfcnotes.NFCNote;
import es.kikisito.nfcnotes.enums.NFCConfig;
import es.kikisito.nfcnotes.enums.NFCMessages;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Count
implements CommandExecutor,
TabExecutor {
    private final Main plugin;

    public Count(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, String[] args) {
        Audience audience = this.plugin.getAdventure().sender(sender);
        if (args.length == 0 && !(sender instanceof Player)) {
            audience.sendMessage(NFCMessages.ONLY_PLAYERS.getString());
        } else if (args.length == 0) {
            if (NFCConfig.MODULES_COUNT_SAME_PLAYER.getBoolean()) {
                Player player = (Player)sender;
                Audience playerAudience = this.plugin.getAdventure().player(player);
                if (player.hasPermission("nfcnotes.count.self")) {
                    double value = this.checkNotes(Objects.requireNonNull(player, "Player must not be null"));
                    playerAudience.sendMessage(NFCMessages.COUNT_SELF.getString("{money}", this.getFormattedValue(value)));
                } else {
                    playerAudience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                }
            } else {
                audience.sendMessage(NFCMessages.MODULE_DISABLED.getString());
            }
        } else if (args.length == 1) {
            if (NFCConfig.MODULES_COUNT_OTHER_PLAYERS.getBoolean()) {
                if (sender.hasPermission("nfcnotes.staff.count.others")) {
                    if (this.plugin.getServer().getPlayer(args[0]) != null) {
                        Player player = this.plugin.getServer().getPlayer(args[0]);
                        double value = this.checkNotes(Objects.requireNonNull(player, "Player must not be null"));
                        audience.sendMessage(NFCMessages.COUNT_OTHER.getString("{money}", this.getFormattedValue(value), "{player}", player.getName()));
                    } else {
                        audience.sendMessage(NFCMessages.PLAYER_NOT_FOUND.getString("{player}", args[0]));
                    }
                } else {
                    audience.sendMessage(NFCMessages.NO_PERMISSION.getString());
                }
            } else {
                audience.sendMessage(NFCMessages.MODULE_DISABLED.getString());
            }
        } else {
            audience.sendMessage(NFCMessages.COUNT_USAGE.getString());
        }
        return true;
    }

    private double checkNotes(Player player) {
        double value = 0.0;
        for (ItemStack i : player.getInventory()) {
            if (!NFCNote.isNFCNote(this.plugin, i)) continue;
            NFCNote nfcNote = new NFCNote(this.plugin, i);
            double amount = nfcNote.getValue() * (double)i.getAmount();
            value += amount;
        }
        return value;
    }

    private String getFormattedValue(double value) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.GERMANY);
        decimalFormatSymbols.setDecimalSeparator(',');
        decimalFormatSymbols.setGroupingSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(NFCConfig.NOTE_DECIMAL_FORMAT.getString(), decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(2);
        return decimalFormat.format(value);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<String> tab = new ArrayList<String>();
        if (args.length == 1 && NFCConfig.MODULES_COUNT_OTHER_PLAYERS.getBoolean() && sender.hasPermission("nfcnotes.staff.count.others")) {
            for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                tab.add(p.getName());
            }
        }
        return tab;
    }
}

