/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes;

import es.kikisito.nfcnotes.Main;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class UpdateChecker {
    private final Main plugin;

    public UpdateChecker(Main plugin) {
        this.plugin = plugin;
    }

    public void getVersion(Consumer<String> consumer) {
        String api = "https://api.github.com/repos/Kikisito/NFCNotes/releases";
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(api)).header("Accept", "application/json").build();
        ((CompletableFuture)((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(body -> {
            try {
                String latestVersion = this.parseLatestVersion((String)body);
                consumer.accept(latestVersion);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
            }
        })).exceptionally(e -> {
            this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
            return null;
        });
    }

    private String parseLatestVersion(String json) {
        int currentIndex = 0;
        while ((currentIndex = json.indexOf("\"prerelease\":false", currentIndex)) != -1) {
            int start;
            int end;
            int nameIndex = json.lastIndexOf("\"tag_name\":", currentIndex);
            if (nameIndex != -1 && (end = json.indexOf(34, start = json.indexOf(34, nameIndex + 11) + 1)) != -1) {
                return json.substring(start, end);
            }
            currentIndex += 20;
        }
        return null;
    }
}

