/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes;

import es.kikisito.nfcnotes.Main;
import es.kikisito.nfcnotes.enums.NFCConfig;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class NFCNote {
    private final ItemStack itemStack;
    private final Component name;
    private final List<Component> lore;
    private final Double value;

    public NFCNote(Main plugin, ItemStack itemStack) {
        this.itemStack = itemStack;
        ItemMeta meta = itemStack.getItemMeta();
        Component component = this.name = meta.hasDisplayName() ? LegacyComponentSerializer.legacySection().deserialize(meta.getDisplayName()) : Component.empty();
        if (meta.hasLore()) {
            ArrayList<Component> loreComponents = new ArrayList<Component>();
            for (String line : meta.getLore()) {
                loreComponents.add(LegacyComponentSerializer.legacySection().deserialize(line));
            }
            this.lore = loreComponents;
        } else {
            this.lore = new ArrayList<Component>();
        }
        NamespacedKey noteValue = new NamespacedKey((Plugin)plugin, "noteValue");
        this.value = (Double)meta.getPersistentDataContainer().get(noteValue, PersistentDataType.DOUBLE);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Component getDisplayName() {
        return this.name;
    }

    public List<Component> getLore() {
        return this.lore;
    }

    public Double getValue() {
        return this.value;
    }

    public static ItemStack createNFCNoteItem(Main plugin, Component name, List<Component> lore, String material, String playername, DecimalFormat decimalFormat, Double money, Integer amount) {
        int maxStackSize;
        String formattedMoney = decimalFormat.format(money);
        ItemStack is = new ItemStack(Material.valueOf((String)material.toUpperCase()), amount.intValue());
        ItemMeta im = is.getItemMeta();
        Component displayName = name.replaceText(builder -> builder.match("\\{issuer\\}").replacement(playername)).replaceText(builder -> builder.match("\\{money\\}").replacement(formattedMoney));
        im.setDisplayName(LegacyComponentSerializer.legacySection().serialize(displayName));
        ArrayList<String> legacyLore = new ArrayList<String>();
        for (Component line : lore) {
            Component processedLine = line.replaceText(builder -> builder.match("\\{issuer\\}").replacement(playername)).replaceText(builder -> builder.match("\\{money\\}").replacement(formattedMoney));
            legacyLore.add(LegacyComponentSerializer.legacySection().serialize(processedLine));
        }
        im.setLore(legacyLore);
        NamespacedKey noteIdentifier = new NamespacedKey((Plugin)plugin, "noteIdentifier");
        NamespacedKey noteValue = new NamespacedKey((Plugin)plugin, "noteValue");
        im.getPersistentDataContainer().set(noteIdentifier, PersistentDataType.STRING, (Object)NFCConfig.NOTE_UUID.getString());
        im.getPersistentDataContainer().set(noteValue, PersistentDataType.DOUBLE, (Object)money);
        if (NFCConfig.NOTE_GLINT_ENABLED.getBoolean()) {
            Enchantment enchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)NFCConfig.NOTE_GLINT_ENCHANTMENT.getString().toLowerCase()));
            int enchantLevel = NFCConfig.NOTE_GLINT_ENCHANTMENT_LEVEL.getInt();
            im.addEnchant(enchant, enchantLevel, true);
            if (NFCConfig.NOTE_GLINT_HIDE_ENCHANTMENT_FLAG.getBoolean()) {
                im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        }
        if ((maxStackSize = NFCConfig.NOTE_MAX_STACK_SIZE.getInt()) != 64) {
            im.setMaxStackSize(Integer.valueOf(maxStackSize));
        }
        im.setCustomModelData(Integer.valueOf(NFCConfig.NOTE_CUSTOM_MODEL_DATA_INTEGER.getInt()));
        is.setItemMeta(im);
        return is;
    }

    public static boolean isNFCNote(Main plugin, ItemStack itemStack) {
        NamespacedKey noteIdentifier = new NamespacedKey((Plugin)plugin, "noteIdentifier");
        NamespacedKey noteValue = new NamespacedKey((Plugin)plugin, "noteValue");
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return false;
        }
        PersistentDataContainer pdc = itemStack.getItemMeta().getPersistentDataContainer();
        if (!pdc.has(noteIdentifier) || !pdc.has(noteValue)) {
            return false;
        }
        String noteUuidString = (String)pdc.get(noteIdentifier, PersistentDataType.STRING);
        if (noteUuidString == null) {
            return false;
        }
        return noteUuidString.equals(NFCConfig.NOTE_UUID.getString());
    }

    @Deprecated(forRemoval=true)
    public static boolean isLegacyNFCNote(ItemStack itemStack) {
        try {
            if (itemStack == null || !itemStack.hasItemMeta()) {
                return false;
            }
            ItemMeta im = itemStack.getItemMeta();
            if (!im.hasAttributeModifiers() || im.getAttributeModifiers(Attribute.LUCK) == null || Objects.requireNonNull(im.getAttributeModifiers(Attribute.LUCK)).iterator().next() == null) {
                return false;
            }
            return ((AttributeModifier)Objects.requireNonNull(im.getAttributeModifiers(Attribute.LUCK)).iterator().next()).getName().equalsIgnoreCase(NFCConfig.NOTE_UUID.getString());
        }
        catch (Exception e) {
            return false;
        }
    }
}

