/*
 * Decompiled with CFR 0.152.
 */
package es.kikisito.nfcnotes;

import es.kikisito.nfcnotes.CustomMetrics;
import es.kikisito.nfcnotes.UpdateChecker;
import es.kikisito.nfcnotes.bukkit.Metrics;
import es.kikisito.nfcnotes.commands.Count;
import es.kikisito.nfcnotes.commands.CreateNote;
import es.kikisito.nfcnotes.commands.Deposit;
import es.kikisito.nfcnotes.commands.NFCNotes;
import es.kikisito.nfcnotes.commands.Withdraw;
import es.kikisito.nfcnotes.enums.NFCConfig;
import es.kikisito.nfcnotes.enums.NFCMessages;
import es.kikisito.nfcnotes.listeners.BlockPlaceListener;
import es.kikisito.nfcnotes.listeners.CraftListener;
import es.kikisito.nfcnotes.listeners.InteractListener;
import es.kikisito.nfcnotes.listeners.JoinListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private Configuration config;
    private FileConfiguration messages;
    @Deprecated
    private String economyPlugin;
    private Economy eco;
    private BukkitAudiences adventure;
    private MiniMessage mm;
    public List<Object> forbiddeninventories = new ArrayList<Object>();

    public void onEnable() {
        Audience audience;
        this.saveDefaultConfig();
        this.loadMessages();
        this.config = this.getConfig();
        NFCConfig.setConfig(this.config);
        NFCMessages.setMessagesFile(this.messages);
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.mm = MiniMessage.miniMessage();
        Audience console = this.adventure.console();
        if (NFCConfig.UPDATE_CHECKER_IS_ENABLED.getBoolean()) {
            new UpdateChecker(this).getVersion(version -> {
                if (!this.getDescription().getVersion().equals(version)) {
                    console.sendMessage((Component)this.mm.deserialize("<yellow>A new version of NFCNotes is available.</yellow>"));
                    console.sendMessage((Component)this.mm.deserialize("<yellow>Version installed: <gold>" + this.getDescription().getVersion() + "</gold>. Latest version: <gold>" + version + "</gold></yellow>"));
                    console.sendMessage((Component)this.mm.deserialize("<yellow>Download it from</yellow> <gold>https://github.com/Kikisito/NFCNotes/releases</gold>"));
                }
            });
        }
        if (!this.isEconomy()) {
            console.sendMessage((Component)this.mm.deserialize("<red>-------------------------------------------------------------</red>"));
            console.sendMessage((Component)this.mm.deserialize("<red>NFCNotes couldn't detect any economy plugin in your server.</red>"));
            console.sendMessage((Component)this.mm.deserialize("<red>If you are using Vault, check that you have installed an economy plugin</red>"));
            console.sendMessage((Component)this.mm.deserialize("<red>-------------------------------------------------------------</red>"));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (NFCConfig.VERSION.getInt() < 13) {
            String outdatedconfig = "<red>Your NFCNotes configuration is outdated. Please, update it or some features will be missed and support won't be provided.</red>";
            console.sendMessage((Component)this.mm.deserialize(outdatedconfig));
            for (Player player : this.getServer().getOnlinePlayers()) {
                if (!player.isOp()) continue;
                audience = this.adventure.player(player);
                audience.sendMessage((Component)this.mm.deserialize(outdatedconfig));
            }
        }
        if (NFCMessages.VERSION.getInt() < 10) {
            String outdatedmsgs = "<red>Your NFCNotes messages file is outdated. Please, update it or some features will be missed and support won't be provided.</red>";
            console.sendMessage((Component)this.mm.deserialize(outdatedmsgs));
            for (Player player : this.getServer().getOnlinePlayers()) {
                if (!player.isOp()) continue;
                audience = this.adventure.player(player);
                audience.sendMessage((Component)this.mm.deserialize(outdatedmsgs));
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)new InteractListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(this), (Plugin)this);
        if (NFCConfig.UPDATE_CHECKER_NOTIFY_ON_JOIN.getBoolean()) {
            this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        }
        this.getCommand("withdraw").setExecutor((CommandExecutor)new Withdraw(this));
        this.getCommand("createnote").setExecutor((CommandExecutor)new CreateNote(this));
        this.getCommand("nfcnotes").setExecutor((CommandExecutor)new NFCNotes(this));
        this.getCommand("deposit").setExecutor((CommandExecutor)new Deposit(this));
        this.getCommand("count").setExecutor((CommandExecutor)new Count(this));
        Metrics metrics = new Metrics(this, 8048);
        new CustomMetrics(metrics);
        for (String invtype : NFCConfig.DISABLED_TABLES.getStrings()) {
            this.forbiddeninventories.add(InventoryType.valueOf((String)invtype));
        }
    }

    public void onDisable() {
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    private boolean isEconomy() {
        try {
            if (NFCConfig.ECONOMY_PLUGIN.getString().equalsIgnoreCase("Vault")) {
                RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
                if (rsp == null) {
                    return false;
                }
                this.eco = (Economy)rsp.getProvider();
                this.economyPlugin = "Vault";
                return true;
            }
            if (NFCConfig.ECONOMY_PLUGIN.getString().equalsIgnoreCase("Essentials")) {
                this.adventure.console().sendMessage((Component)this.mm.deserialize("<gold>Essentials Economy won't be supported anymore soon in the future. Please, switch to a Vault compatible economy plugin as soon as possible.</gold>"));
                this.economyPlugin = "Essentials";
                return true;
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public Economy getVaultEco() {
        return this.eco;
    }

    @Deprecated
    public String getEco() {
        return this.economyPlugin;
    }

    public FileConfiguration getMessages() {
        return this.messages;
    }

    public void loadMessages() {
        try {
            File messages = new File(this.getDataFolder(), "messages.yml");
            if (!messages.exists()) {
                messages.getParentFile().mkdirs();
                this.saveResource("messages.yml", false);
            }
            this.messages = new YamlConfiguration();
            this.messages.load(messages);
            NFCMessages.setMessagesFile(this.messages);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void reloadPlugin() {
        try {
            File config = new File(this.getDataFolder(), "config.yml");
            if (!config.exists()) {
                config.getParentFile().mkdirs();
                this.saveResource("config.yml", false);
            }
            this.getConfig().load(config);
            this.loadMessages();
            this.forbiddeninventories = new ArrayList<Object>();
            for (String invtype : NFCConfig.DISABLED_TABLES.getStrings()) {
                this.forbiddeninventories.add(InventoryType.valueOf((String)invtype));
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public BukkitAudiences getAdventure() {
        return this.adventure;
    }

    public MiniMessage getMiniMessage() {
        return this.mm;
    }
}

