/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.keehl.elevators.util.config.BlankConfig;
import me.keehl.elevators.util.config.Comments;
import me.keehl.elevators.util.config.Config;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.ConfigFieldName;
import me.keehl.elevators.util.config.ExpandableConfig;
import me.keehl.elevators.util.config.nodes.ConfigNode;

public class ConfigConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> deserializeNodeWithFieldAndObject(ConfigNode<?> parentNode, String key, Object object, ConfigConverter.FieldData fieldData) throws Exception {
        ConfigNode<?> myNode;
        Object rawData = parentNode.getRoot().getObjectAtPath(key, new HashMap());
        if (!(object instanceof Config) || object.getClass().isInterface()) {
            object = fieldData.getFieldClass() == Config.class ? new BlankConfig(rawData) : fieldData.getFieldClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if ((myNode = ConfigConverter.createNodeWithData(parentNode, key, object, fieldData.getField())).getValue() instanceof Config) {
            ((Config)myNode.getValue()).setKey(key);
        }
        this.constructMapToConfig(parentNode, myNode, rawData, fieldData);
        if (myNode.getValue() instanceof Config) {
            ((Config)myNode.getValue()).onLoad();
        }
        return myNode;
    }

    public void constructMapToConfig(ConfigNode<?> parentNode, ConfigNode<?> myNode, Object rawData, ConfigConverter.FieldData fieldData) throws Exception {
        Object obj;
        Config configObj = (Config)myNode.getValue();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = fieldData.getFieldClass(); current != null; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        for (Field childField : fields) {
            if (Modifier.isTransient(childField.getModifiers()) || Modifier.isFinal(childField.getModifiers())) continue;
            childField.setAccessible(true);
            ConfigConverter.FieldData childFieldData = new ConfigConverter.FieldData(childField);
            ConfigFieldName fieldName = childField.getAnnotation(ConfigFieldName.class);
            String path = fieldName != null ? fieldName.value() : childField.getName();
            obj = childField.get(configObj);
            if (obj == null) {
                try {
                    obj = childField.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if (Map.class.isAssignableFrom(childField.getType())) {
                        obj = new HashMap();
                    }
                    if (Set.class.isAssignableFrom(childField.getType())) {
                        obj = new HashSet();
                    }
                    if (List.class.isAssignableFrom(childField.getType())) {
                        obj = new ArrayList();
                    }
                    if (!childField.isEnumConstant()) continue;
                    obj = childField.getType().getEnumConstants()[0];
                }
            }
            obj = parentNode.getRoot().getObjectAtPath(myNode.getChildPath(path), obj);
            ConfigConverter converter = ConfigConverter.getConverter(childField.getType());
            ConfigNode<?> childNode = converter != null ? converter.deserializeNodeWithFieldAndObject(myNode, path, obj, childFieldData) : ConfigConverter.createNodeWithData(myNode, path, obj, childField);
            if (childField.isAnnotationPresent(Comments.class)) {
                Comments comments = childField.getAnnotation(Comments.class);
                for (String comment : comments.value()) {
                    childNode.addComment(comment);
                }
            }
            myNode.getChildren().add(childNode);
            if (!(configObj instanceof ExpandableConfig)) continue;
            ((ExpandableConfig)configObj).data.put(path, childNode);
        }
        if (!(configObj instanceof ExpandableConfig)) {
            return;
        }
        ExpandableConfig expandableConfig = (ExpandableConfig)configObj;
        expandableConfig.parentNode = myNode;
        if (!(rawData instanceof Map)) {
            return;
        }
        Map mapData = (Map)rawData;
        for (Object objKey : mapData.keySet()) {
            String key = objKey.toString();
            obj = mapData.get(key);
            ConfigConverter.FieldData childFieldData = new ConfigConverter.FieldData(null, obj.getClass(), obj.getClass());
            ConfigConverter converter = ConfigConverter.getConverter(obj.getClass());
            ConfigNode<?> childNode = converter != null ? converter.deserializeNodeWithFieldAndObject(myNode, key, obj, childFieldData) : ConfigConverter.createNodeWithData(myNode, key, obj, null);
            myNode.getChildren().add(childNode);
            expandableConfig.setData(key, childNode.getValue());
        }
    }

    @Override
    public Object serializeNodeToObject(ConfigNode<?> node) throws Exception {
        ((Config)node.getValue()).onSave();
        if (node.getValue() instanceof BlankConfig) {
            return ((BlankConfig)node.getValue()).convertToObject();
        }
        LinkedHashMap newMap = new LinkedHashMap();
        for (ConfigNode<?> childNode : node.getChildren()) {
            Object value = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(value.getClass());
            if (converter != null) {
                value = converter.serializeNodeToObject(childNode);
            }
            newMap.put(childNode.getKey(), value);
        }
        return newMap;
    }

    @Override
    public Object serializeValueToObject(Object configObj) throws Exception {
        if (!(configObj instanceof Config)) {
            return new HashMap();
        }
        Config config = (Config)configObj;
        config.onSave();
        if (configObj instanceof BlankConfig) {
            return ((BlankConfig)configObj).convertToObject();
        }
        LinkedHashMap newMap = new LinkedHashMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = configObj.getClass(); current != null; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        for (Field childField : fields) {
            if (Modifier.isTransient(childField.getModifiers()) || Modifier.isFinal(childField.getModifiers())) continue;
            childField.setAccessible(true);
            String path = childField.getName();
            HashSet<Object> obj = childField.get(configObj);
            if (obj == null) {
                try {
                    obj = childField.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if (Map.class.isAssignableFrom(childField.getType())) {
                        obj = new HashMap();
                    }
                    if (Set.class.isAssignableFrom(childField.getType())) {
                        obj = new HashSet();
                    }
                    if (!childField.isEnumConstant()) continue;
                    obj = childField.getType().getEnumConstants()[0];
                }
            }
            if (obj == null) continue;
            ConfigConverter converter = ConfigConverter.getConverter(obj.getClass());
            if (converter != null) {
                obj = converter.serializeValueToObject(obj);
            }
            newMap.put(path, obj);
        }
        if (!(configObj instanceof ExpandableConfig)) {
            return newMap;
        }
        ExpandableConfig expandableConfig = (ExpandableConfig)configObj;
        for (String key : expandableConfig.data.keySet()) {
            ConfigNode<?> childNode = expandableConfig.data.get(key);
            Object obj = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(obj.getClass());
            if (converter != null) {
                obj = converter.serializeValueToObject(obj);
            }
            newMap.put(key, obj);
        }
        return newMap;
    }

    @Override
    public boolean supports(Class<?> type) {
        return Config.class.isAssignableFrom(type);
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        return "Config";
    }
}

