/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.nodes.ClassicConfigNode;
import me.keehl.elevators.util.config.nodes.ConfigNode;

public class ArrayConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> deserializeNodeWithFieldAndObject(ConfigNode<?> parentNode, String key, Object object, ConfigConverter.FieldData fieldData) throws Exception {
        ConfigConverter.FieldData childFieldData = fieldData.getGenericData()[0];
        if (childFieldData == null) {
            return null;
        }
        ConfigConverter converter = ConfigConverter.getConverter(childFieldData.getFieldClass());
        ArrayList<Object> currentValues = new ArrayList<Object>(object instanceof List ? (List<Object>)object : Arrays.asList((Object[])object));
        ArrayList values2 = new ArrayList();
        ArrayList childrenNodes = new ArrayList();
        for (Object e : currentValues) {
            if (converter != null) {
                ConfigNode<?> childNode = converter.deserializeNodeWithFieldAndObject(parentNode, e.toString(), e, childFieldData);
                values2.add(childNode.getValue());
                childrenNodes.add(childNode);
                continue;
            }
            childrenNodes.add(ConfigConverter.createNodeWithData(parentNode, e.toString(), e, null));
        }
        ConfigNode<?> myNode = ArrayConfigConverter.createNodeWithData(parentNode, key, values2.toArray(), fieldData.getField());
        myNode.getChildren().addAll(childrenNodes);
        return myNode;
    }

    @Override
    public Object serializeNodeToObject(ConfigNode<?> node) throws Exception {
        ArrayList values2 = new ArrayList();
        for (ConfigNode<?> childNode : node.getChildren()) {
            Object value = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(value.getClass());
            if (converter != null) {
                value = converter.serializeNodeToObject(childNode);
            }
            values2.add(value);
        }
        return values2;
    }

    private Object[] convertToObjectArray(Object array) {
        Class<?> ofArray = array.getClass().getComponentType();
        if (ofArray.isPrimitive()) {
            ArrayList<Object> ar = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                ar.add(Array.get(array, i));
            }
            return ar.toArray();
        }
        return (Object[])array;
    }

    @Override
    public Object serializeValueToObject(Object arrayObj) throws Exception {
        Object[] array = this.convertToObjectArray(arrayObj);
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (Object item : array) {
            ConfigConverter converter = ConfigConverter.getConverter(item.getClass());
            if (converter != null) {
                item = converter.serializeValueToObject(item);
            }
            values2.add(item);
        }
        return values2;
    }

    @Override
    public boolean supports(Class<?> type) {
        return type.isArray();
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        if (node instanceof ClassicConfigNode) {
            ClassicConfigNode classicNode = (ClassicConfigNode)node;
            Class<?> singleType = classicNode.getField().getType().getComponentType();
            return singleType.getSimpleName() + " Array";
        }
        return "Array";
    }
}

