/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import com.bgsoftware.superiorskyblock.api.SuperiorSkyblockAPI;
import com.bgsoftware.superiorskyblock.api.events.PluginInitializeEvent;
import com.bgsoftware.superiorskyblock.api.island.Island;
import com.bgsoftware.superiorskyblock.api.island.IslandPrivilege;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.ResourceHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import me.keehl.elevators.services.ElevatorListenerService;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.ItemStack;

public class SuperiorSkyblock2Hook
extends ProtectionHook {
    private static final String USE_ELEVATOR_FLAG = "elevators_use";
    private static final String EDIT_NAME_ELEVATOR_FLAG = "elevators_edit_name";
    private static final String EDIT_SETTINGS_ELEVATOR_FLAG = "elevators_edit_settings";
    private static IslandPrivilege USE_ELEVATOR;
    private static IslandPrivilege EDIT_NAME_ELEVATOR;
    private static IslandPrivilege EDIT_SETTINGS_ELEVATOR;
    private static boolean registered;

    public SuperiorSkyblock2Hook() {
        super("SuperiorSkyblock2");
        ElevatorListenerService.registerEventExecutor(PluginInitializeEvent.class, EventPriority.NORMAL, this::onSSB2Enable);
    }

    @Override
    public void onInit() {
    }

    public void onSSB2Enable(PluginInitializeEvent e) {
        try {
            IslandPrivilege.register((String)USE_ELEVATOR_FLAG);
            IslandPrivilege.register((String)EDIT_NAME_ELEVATOR_FLAG);
            IslandPrivilege.register((String)EDIT_SETTINGS_ELEVATOR_FLAG);
            USE_ELEVATOR = IslandPrivilege.getByName((String)USE_ELEVATOR_FLAG);
            EDIT_NAME_ELEVATOR = IslandPrivilege.getByName((String)EDIT_NAME_ELEVATOR_FLAG);
            EDIT_SETTINGS_ELEVATOR = IslandPrivilege.getByName((String)EDIT_SETTINGS_ELEVATOR_FLAG);
            Elevators.getElevatorsLogger().info("Hooked into SuperiorSkyblock2 correctly");
            registered = true;
        }
        catch (Exception ex) {
            Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed to register SSB2 hook. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(ex));
        }
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        if (!registered) {
            return true;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)elevator.getLocation());
        if (island != null) {
            return island.hasPermission(SuperiorSkyblockAPI.getPlayer((UUID)player.getUniqueId()), USE_ELEVATOR);
        }
        return true;
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        if (!registered) {
            return null;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)elevator.getLocation());
        if (island == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether island");
        lore.add(String.valueOf(ChatColor.GRAY) + "guests are blocked from");
        lore.add(String.valueOf(ChatColor.GRAY) + "using this Elevator.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "SuperiorSkyblock2", Material.DIAMOND, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        if (!registered) {
            return true;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)elevator.getLocation());
        if (island != null) {
            return island.hasPermission(SuperiorSkyblockAPI.getPlayer((UUID)player.getUniqueId()), EDIT_NAME_ELEVATOR);
        }
        return true;
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        if (!registered) {
            return true;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)elevator.getLocation());
        if (island != null) {
            return island.hasPermission(SuperiorSkyblockAPI.getPlayer((UUID)player.getUniqueId()), EDIT_SETTINGS_ELEVATOR);
        }
        return false;
    }

    static {
        registered = false;
    }
}

