/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import dev.lone.itemsadder.api.CustomStack;
import dev.lone.itemsadder.api.Events.ItemsAdderLoadDataEvent;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.models.hooks.ItemsHook;
import me.keehl.elevators.services.ElevatorListenerService;
import me.keehl.elevators.services.ElevatorRecipeService;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.ItemStack;

public class ItemsAdderHook
extends ItemsHook {
    @Override
    public void onInit() {
        Elevators.log("ItemsAdder has been hooked, however has not finished loading yet. Waiting for ItemsAdder Data Load.");
        ElevatorListenerService.registerEventExecutor(ItemsAdderLoadDataEvent.class, EventPriority.MONITOR, event -> {
            Elevators.log("Items Adder has finished loading. Reloading recipes for Items Adder support");
            Elevators.pushLog();
            ElevatorRecipeService.refreshRecipes();
            Elevators.popLog();
        });
    }

    @Override
    public ItemStack createItemStackFromKey(NamespacedKey key) {
        CustomStack stack = CustomStack.getInstance((String)key.toString());
        if (stack == null) {
            return null;
        }
        return stack.getItemStack();
    }

    @Override
    public NamespacedKey getKeyFromItemStack(ItemStack item) {
        CustomStack stack = CustomStack.byItemStack((ItemStack)item);
        if (stack == null) {
            return null;
        }
        return new NamespacedKey(stack.getNamespace(), stack.getId());
    }
}

