/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.griefdefender.api.claim.TrustTypes;
import java.util.ArrayList;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GriefDefenderHook
extends ProtectionHook {
    public GriefDefenderHook() {
        super("GriefDefender");
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        Claim claim = GriefDefender.getCore().getClaimAt((Object)elevator.getLocation());
        if (claim == null || claim.isWilderness()) {
            return true;
        }
        return claim.canUseBlock((Object)elevator.getShulkerBox(), (Object)elevator.getLocation(), GriefDefender.getCore().getUser(player.getUniqueId()), TrustTypes.ACCESSOR);
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        Claim claim = GriefDefender.getCore().getClaimAt((Object)elevator.getLocation());
        if (claim == null) {
            return true;
        }
        if (claim.isWilderness()) {
            return true;
        }
        return claim.canUseBlock((Object)elevator.getShulkerBox(), (Object)elevator.getLocation(), GriefDefender.getCore().getUser(player.getUniqueId()), TrustTypes.ACCESSOR);
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        Claim claim = GriefDefender.getCore().getClaimAt((Object)elevator.getLocation());
        if (claim == null) {
            return true;
        }
        if (claim.isWilderness()) {
            return true;
        }
        return claim.canUseBlock((Object)elevator.getShulkerBox(), (Object)elevator.getLocation(), GriefDefender.getCore().getUser(player.getUniqueId()), TrustTypes.MANAGER);
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        Claim claim = GriefDefender.getCore().getClaimAt((Object)elevator.getLocation());
        if (claim == null || claim.isWilderness()) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether claim");
        lore.add(String.valueOf(ChatColor.GRAY) + "guests are blocked from");
        lore.add(String.valueOf(ChatColor.GRAY) + "using this Elevator.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Grief Defender", Material.SHIELD, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }
}

