/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.configs.versions.configv5;

import java.util.HashMap;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.models.hooks.ProtectionHook;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.configs.ConfigVersion;
import me.keehl.elevators.services.configs.versions.configv4_0_2.V4_0_2ConfigRecipe;
import me.keehl.elevators.services.configs.versions.configv4_0_2.V4_0_2ConfigRoot;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigEffect;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigElevatorType;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigHookData;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigLocale;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigRecipe;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigRoot;
import org.bukkit.DyeColor;

public class V5ConfigVersion
extends ConfigVersion<V4_0_2ConfigRoot, V5ConfigRoot> {
    @Override
    public V5ConfigRoot upgradeVersion(V4_0_2ConfigRoot currentConfig) {
        Elevators.getElevatorsLogger().info("Converting config from V4.0.2 - V5.0.0");
        V5ConfigRoot newConfig = new V5ConfigRoot();
        newConfig.updateCheckerEnabled = currentConfig.updateCheckerEnabled;
        newConfig.forceFacingUpwards = currentConfig.forceFacingUpwards;
        V5ConfigLocale newLocale = new V5ConfigLocale();
        newLocale.cantCreateMessage = currentConfig.cantCreateMessage;
        newLocale.cantUseMessage = currentConfig.cantUseMessage;
        newLocale.cantGiveMessage = currentConfig.cantGiveMessage;
        newLocale.cantReloadMessage = currentConfig.cantReloadMessage;
        newLocale.notEnoughRoomGiveMessage = currentConfig.notEnoughRoomGiveMessage;
        newLocale.givenElevatorMessage = currentConfig.givenElevatorMessage;
        newLocale.worldDisabledMessage = currentConfig.worldDisabledMessage;
        newConfig.locale = newLocale;
        for (ProtectionHook hook : ElevatorHookService.getProtectionHooks()) {
            V5ConfigHookData hookData = new V5ConfigHookData();
            hookData.blockNonMemberUseDefault = currentConfig.claimProtectionDefault;
            if (newConfig.protectionHooks == null) {
                newConfig.protectionHooks = new HashMap<String, V5ConfigHookData>();
            }
            newConfig.protectionHooks.put(hook.getConfigKey(), hookData);
        }
        newConfig.disabledWorlds = currentConfig.disabledWorlds;
        V5ConfigEffect creeperEffect = new V5ConfigEffect();
        creeperEffect.file = "Creeper.png";
        creeperEffect.scale = 1;
        creeperEffect.duration = 1.0f;
        creeperEffect.useHolo = false;
        creeperEffect.background = "#FFFFFF";
        newConfig.effects = new HashMap<String, V5ConfigEffect>();
        newConfig.effects.put("creeper", creeperEffect);
        V5ConfigElevatorType defaultElevator = new V5ConfigElevatorType();
        defaultElevator.usePermission = "elevators.use";
        defaultElevator.dyePermission = "elevators.dye";
        defaultElevator.displayName = currentConfig.displayName;
        defaultElevator.maxDistance = currentConfig.maxDistance;
        defaultElevator.maxSolidBlocks = currentConfig.maxSolidBlocks;
        defaultElevator.maxStackSize = currentConfig.maxStackSize;
        defaultElevator.stopObstruction = currentConfig.stopObstruction;
        defaultElevator.checkColor = currentConfig.checkColor;
        defaultElevator.checkPerms = currentConfig.checkPerms;
        defaultElevator.canExplode = currentConfig.canExplode;
        defaultElevator.loreLines = currentConfig.lore;
        defaultElevator.actions.up = currentConfig.actions.up;
        defaultElevator.actions.down = currentConfig.actions.down;
        defaultElevator.recipes = new HashMap<String, V5ConfigRecipe>();
        for (String recipeKey : currentConfig.recipes.keySet()) {
            V4_0_2ConfigRecipe currentRecipe = currentConfig.recipes.get(recipeKey);
            V5ConfigRecipe newRecipe = new V5ConfigRecipe();
            newRecipe.defaultOutputColor = DyeColor.valueOf((String)currentConfig.defaultColor);
            newRecipe.supportMultiColorOutput = currentRecipe.coloredCrafting;
            newRecipe.supportMultiColorMaterials = currentRecipe.coloredCrafting;
            newRecipe.recipe = currentRecipe.recipe;
            newRecipe.craftPermission = currentRecipe.permission;
            newRecipe.materials = currentRecipe.materials;
            defaultElevator.recipes.put(recipeKey, newRecipe);
        }
        newConfig.elevators = new HashMap<String, V5ConfigElevatorType>();
        newConfig.elevators.put("DEFAULT", defaultElevator);
        defaultElevator.onLoad();
        return newConfig;
    }
}

