/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.models.ElevatorAction;
import me.keehl.elevators.models.ElevatorRecipeGroup;
import me.keehl.elevators.models.ElevatorSetting;
import me.keehl.elevators.services.ElevatorActionService;
import me.keehl.elevators.services.ElevatorHologramService;
import me.keehl.elevators.services.ElevatorRecipeService;
import me.keehl.elevators.services.ElevatorSettingService;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigElevatorType;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigSettings;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;

public class ElevatorType
extends ConfigElevatorType {
    private transient String elevatorTypeKey;
    private final transient List<ElevatorAction> actionsUp = new ArrayList<ElevatorAction>();
    private final transient List<ElevatorAction> actionsDown = new ArrayList<ElevatorAction>();

    public String getTypeKey() {
        return this.elevatorTypeKey.toUpperCase();
    }

    public List<ElevatorAction> getActionsUp() {
        return this.actionsUp;
    }

    public List<ElevatorAction> getActionsDown() {
        return this.actionsDown;
    }

    public List<ElevatorRecipeGroup> getRecipeGroups() {
        return new ArrayList<ElevatorRecipeGroup>(this.recipes.values());
    }

    public ConfigElevatorType getConfig() {
        return this;
    }

    public ConfigSettings getSettingsConfig() {
        return this.settings;
    }

    public void setDisplayName(String displayName) {
        this.settings.displayName = displayName;
        ElevatorRecipeService.refreshRecipes();
        Elevators.getInstance().saveConfig();
    }

    public void setUsePermission(String usePermission) {
        this.settings.usePermission = usePermission;
        Elevators.getInstance().saveConfig();
    }

    public void setDyePermission(String dyePermission) {
        this.settings.dyePermission = dyePermission;
        Elevators.getInstance().saveConfig();
    }

    public void setMaxDistanceAllowedBetweenElevators(int maxDistance) {
        this.settings.maxDistance = maxDistance;
        Elevators.getInstance().saveConfig();
    }

    public void setMaxStackSize(int maxStackSize) {
        this.settings.maxStackSize = maxStackSize;
        Elevators.getInstance().saveConfig();
    }

    public void setMaxSolidBlocksAllowedBetweenElevators(int maxSolidBlocks) {
        this.settings.maxSolidBlocks = maxSolidBlocks;
        Elevators.getInstance().saveConfig();
    }

    public void setCheckDestinationElevatorType(boolean checkType) {
        this.settings.classCheck = checkType;
        Elevators.getInstance().saveConfig();
    }

    public void setElevatorRequiresPermissions(boolean checkPerms) {
        this.settings.checkPerms = checkPerms;
        Elevators.getInstance().saveConfig();
    }

    public void setCanElevatorExplode(boolean canExplode) {
        this.settings.canExplode = canExplode;
        Elevators.getInstance().saveConfig();
    }

    public void setCanDye(boolean supportDying) {
        this.settings.supportDying = supportDying;
        Elevators.getInstance().saveConfig();
    }

    public void setStopsObstructedTeleportation(boolean stopsObstruction) {
        this.settings.stopObstruction = stopsObstruction;
        Elevators.getInstance().saveConfig();
    }

    public void setShouldValidateColor(boolean checkColor) {
        this.settings.checkColor = checkColor;
        Elevators.getInstance().saveConfig();
    }

    public void setShouldAllowIndividualEdit(boolean allowIndividualEdit) {
        this.settings.canEditIndividually = allowIndividualEdit;
        Elevators.getInstance().saveConfig();
    }

    public void setHologramLines(List<String> holoLines) {
        boolean checkCreate = this.settings.hologramLines.isEmpty();
        this.settings.hologramLines = holoLines;
        Elevators.getInstance().saveConfig();
        if (!ElevatorHologramService.canUseHolograms()) {
            return;
        }
        this.updateAllHolograms(checkCreate);
    }

    public void updateAllHolograms(boolean chunkCheck) {
        Elevators.getFoliaLib().getScheduler().runNextTick(task -> ElevatorHologramService.updateHologramsOfElevatorType(this));
        if (!chunkCheck) {
            return;
        }
        Elevators.getFoliaLib().getScheduler().runNextTick(task -> {
            for (World world : Bukkit.getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    ElevatorHologramService.updateHologramsInChunk(chunk);
                }
            }
        });
    }

    public void setLore(List<String> loreLines) {
        this.settings.loreLines = loreLines;
        ElevatorRecipeService.refreshRecipes();
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void onSave() {
        this.actions.up = this.getActionsUp().stream().map(ElevatorAction::serialize).collect(Collectors.toList());
        this.actions.down = this.getActionsDown().stream().map(ElevatorAction::serialize).collect(Collectors.toList());
        for (ElevatorSetting<?> setting : ElevatorSettingService.getElevatorSettings()) {
            setting.applyToElevatorSettings(this, this.settings);
        }
    }

    @Override
    public void onLoad() {
        this.getActionsUp().clear();
        this.getActionsDown().clear();
        this.getActionsUp().addAll(this.actions.up.stream().map(i -> ElevatorActionService.createActionFromString(this, i)).filter(Objects::nonNull).collect(Collectors.toList()));
        this.getActionsDown().addAll(this.actions.down.stream().map(i -> ElevatorActionService.createActionFromString(this, i)).filter(Objects::nonNull).collect(Collectors.toList()));
        HashMap<String, ElevatorRecipeGroup> newRecipes = new HashMap<String, ElevatorRecipeGroup>();
        for (String key : this.recipes.keySet()) {
            ElevatorRecipeGroup recipeGroup = (ElevatorRecipeGroup)this.recipes.get(key);
            newRecipes.put(key.toUpperCase(), recipeGroup);
            recipeGroup.setKey(key.toUpperCase());
        }
        this.recipes = newRecipes;
    }

    @Override
    public void setKey(String key) {
        this.elevatorTypeKey = key.toUpperCase();
    }
}

