/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.util.Random;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.VersionHelper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ShulkerBoxHelper {
    private static final Random random = new Random();

    public static ShulkerBox setShulkerBoxName(ShulkerBox box, String name) {
        box.setCustomName(name);
        box.update(true, true);
        return ShulkerBoxHelper.getShulkerBox(box.getBlock());
    }

    public static void setFacingUp(ShulkerBox box) {
        BlockData blockData = box.getBlockData();
        if (VersionHelper.doesVersionSupportShulkerFacingAPI() && blockData instanceof Directional) {
            ((Directional)blockData).setFacing(BlockFace.UP);
            box.setBlockData(blockData);
        } else {
            box.setRawData((byte)6);
        }
        box.update(true);
    }

    public static boolean isShulkerBox(BlockState state) {
        return state instanceof ShulkerBox;
    }

    public static ShulkerBox getShulkerBox(Block block) {
        if (ItemStackHelper.isNotShulkerBox(block.getType())) {
            return null;
        }
        if (Elevators.getFoliaLib().isPaper()) {
            return (ShulkerBox)block.getState(false);
        }
        return (ShulkerBox)block.getState();
    }

    public static ShulkerBox clearContents(ShulkerBox box) {
        box.getInventory().setItem(0, null);
        box.getInventory().setContents(new ItemStack[box.getInventory().getSize()]);
        box.update(true, true);
        return ShulkerBoxHelper.getShulkerBox(box.getBlock());
    }

    public static void playClose(ShulkerBox box) {
        VersionHelper.closeShulkerBox(box);
    }

    public static void playOpen(ShulkerBox box) {
        VersionHelper.openShulkerBox(box);
    }

    public static boolean fakeDispense(Block block, ItemStack item) {
        if (block.getType() != Material.DISPENSER) {
            return false;
        }
        Dispenser dispenser = Elevators.getFoliaLib().isPaper() ? (Dispenser)block.getState(false) : (Dispenser)block.getState();
        Directional directional = (Directional)block.getBlockData();
        boolean match = false;
        for (ItemStack tempItem : dispenser.getInventory().getContents()) {
            if (tempItem == null || !tempItem.isSimilar(item)) continue;
            match = true;
            tempItem.setAmount(tempItem.getAmount() - 1);
            break;
        }
        if (!match) {
            return false;
        }
        item = item.clone();
        item.setAmount(1);
        BlockFace face = directional.getFacing();
        double d0 = (double)block.getX() + 0.7 * (double)face.getModX();
        double d1 = (double)block.getY() + 0.7 * (double)face.getModY();
        double d2 = (double)block.getZ() + 0.7 * (double)face.getModZ();
        d1 = face == BlockFace.UP || face == BlockFace.DOWN ? (d1 -= 0.125) : (d1 -= 0.15625);
        Location spawnLocation = new Location(block.getWorld(), d0, d1, d2);
        double power = 6.0;
        VersionHelper.dropItem(block.getWorld(), spawnLocation, item, newItem -> {
            double d3 = random.nextDouble() * 0.1 + 0.2;
            double velX = random.nextGaussian() * (double)0.0075f * power + (double)face.getModX() * d3;
            double velY = random.nextGaussian() * (double)0.0075f * power + (double)0.2f;
            double velZ = random.nextGaussian() * (double)0.0075f * power + (double)face.getModZ() * d3;
            newItem.setVelocity(new Vector(velX, velY, velZ));
        });
        return true;
    }
}

