/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.util.List;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.events.ElevatorUseEvent;
import me.keehl.elevators.helpers.ElevatorGUIHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorAction;
import me.keehl.elevators.models.ElevatorEventData;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorHologramService;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.ElevatorObstructionService;
import me.keehl.elevators.services.ElevatorSettingService;
import me.keehl.elevators.services.ElevatorVersionService;
import me.keehl.elevators.util.InternalElevatorSettingType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ElevatorHelper {
    public static boolean isElevator(InventoryHolder inventoryHolder) {
        if (!(inventoryHolder instanceof BlockState)) {
            return false;
        }
        return ElevatorHelper.isElevator((BlockState)inventoryHolder);
    }

    public static boolean isElevator(BlockState blockState) {
        if (!ShulkerBoxHelper.isShulkerBox(blockState)) {
            return false;
        }
        return ElevatorVersionService.getElevatorType((ShulkerBox)blockState, false) != null;
    }

    public static boolean isElevator(ShulkerBox box) {
        return ElevatorVersionService.getElevatorType(box, false) != null;
    }

    public static boolean isElevator(Block block) {
        return ElevatorVersionService.getElevatorType(block) != null;
    }

    public static boolean isElevator(ItemStack itemStack) {
        return ElevatorVersionService.getElevatorType(itemStack) != null;
    }

    public static boolean isElevator(Item item) {
        return ElevatorVersionService.getElevatorType(item.getItemStack()) != null;
    }

    public static ElevatorType getElevatorType(ItemStack item) {
        return ElevatorVersionService.getElevatorType(item);
    }

    public static ElevatorType getElevatorType(Block block) {
        return ElevatorVersionService.getElevatorType(block);
    }

    public static ElevatorType getElevatorType(ShulkerBox box) {
        return ElevatorVersionService.getElevatorType(box, true);
    }

    public static ElevatorType getElevatorType(ShulkerBox box, boolean updateBlock) {
        return ElevatorVersionService.getElevatorType(box, updateBlock);
    }

    public static int getFloorNumberOrCount(Elevator elevator, boolean stopAtProvidedBox) {
        ElevatorEventData searchResult;
        Location startingLocation = elevator.getLocation();
        while ((searchResult = ElevatorHelper.findDestinationElevator(null, startingLocation, elevator, (byte)-1, false, false, true)) != null) {
            startingLocation = searchResult.getDestination().getLocation();
        }
        if (elevator.getLocation().getBlockY() == startingLocation.getBlockY() && stopAtProvidedBox) {
            return 1;
        }
        int floor = 1;
        while ((searchResult = ElevatorHelper.findDestinationElevator(null, startingLocation, elevator, (byte)1, false, false, true)) != null) {
            ++floor;
            startingLocation = searchResult.getDestination().getLocation();
            if (!stopAtProvidedBox || startingLocation.getY() != (double)elevator.getLocation().getBlockY()) continue;
            break;
        }
        return floor;
    }

    public static ElevatorEventData findDestinationElevator(Player player, Elevator elevator, byte direction) {
        return ElevatorHelper.findDestinationElevator(player, elevator.getLocation(), elevator, direction, false, false, false);
    }

    public static ElevatorEventData findDestinationElevator(Player player, Location origin, Elevator elevator, byte direction, boolean ignoreSolidBlockCheck, boolean ignoreDistanceCheck, boolean ignoreObstructionCheck) {
        if ((direction = (byte)(direction > 0 ? 1 : -1)) == -1 && origin.getBlockY() == VersionHelper.getWorldMinHeight(origin.getWorld())) {
            return null;
        }
        World world = origin.getWorld();
        int worldMinHeight = VersionHelper.getWorldMinHeight(world);
        int maxDistance = (Integer)ElevatorSettingService.getElevatorSettingValue(elevator, InternalElevatorSettingType.MAX_DISTANCE);
        if (maxDistance == -1 || ignoreDistanceCheck) {
            maxDistance = Short.MAX_VALUE;
        }
        int endPointY = Math.min(Math.max(origin.getBlockY() + maxDistance * direction, worldMinHeight), world.getMaxHeight());
        boolean stopsObstruction = (Boolean)ElevatorSettingService.getElevatorSettingValue(elevator, InternalElevatorSettingType.STOP_OBSTRUCTION);
        boolean checkColor = (Boolean)ElevatorSettingService.getElevatorSettingValue(elevator, InternalElevatorSettingType.CHECK_COLOR);
        boolean checksClass = (Boolean)ElevatorSettingService.getElevatorSettingValue(elevator, InternalElevatorSettingType.CLASS_CHECK);
        int maxSolidBlocks = (Integer)ElevatorSettingService.getElevatorSettingValue(elevator, InternalElevatorSettingType.MAX_SOLID_BLOCKS);
        int solidBlocks = maxSolidBlocks == -1 || ignoreSolidBlockCheck ? Short.MIN_VALUE : 0;
        Location tempLocation = origin.clone();
        do {
            double addition;
            ShulkerBox tempShulkerBox;
            Block tempBlock;
            if ((tempBlock = (tempLocation = tempLocation.add(0.0, (double)direction, 0.0)).getBlock()).getType().isSolid()) {
                ++solidBlocks;
            }
            if ((tempShulkerBox = ShulkerBoxHelper.getShulkerBox(tempBlock)) == null) continue;
            ElevatorType tempElevatorType = ElevatorHelper.getElevatorType(tempShulkerBox, false);
            Elevator tempElevator = new Elevator(tempShulkerBox, tempElevatorType);
            if (tempElevatorType == null || checksClass && !elevator.getElevatorType().equals(tempElevatorType)) continue;
            if (--solidBlocks >= maxSolidBlocks) {
                return null;
            }
            if (tempShulkerBox.getColor() != elevator.getDyeColor() && checkColor) continue;
            if (!stopsObstruction || ignoreObstructionCheck) {
                return new ElevatorEventData(elevator, tempElevator, direction, 0.0);
            }
            double d = addition = player != null ? ElevatorObstructionService.getHitBoxAddition(tempBlock.getRelative(BlockFace.UP), player) : 0.0;
            if (!(addition >= 0.0)) continue;
            return new ElevatorEventData(elevator, tempElevator, direction, Math.abs(addition));
        } while (tempLocation.getBlockY() != endPointY);
        return null;
    }

    public static void setElevatorDisabled(ShulkerBox shulkerBox) {
        shulkerBox.setMetadata("elevator-disabled", (MetadataValue)new FixedMetadataValue((Plugin)Elevators.getInstance(), (Object)true));
    }

    public static void setElevatorEnabled(ShulkerBox shulkerBox) {
        shulkerBox.removeMetadata("elevator-disabled", (Plugin)Elevators.getInstance());
    }

    public static void onElevatorInteract(Player player, PlayerInteractEvent event, Elevator elevator) {
        if (ElevatorHelper.isElevatorDisabled(elevator.getShulkerBox())) {
            return;
        }
        ElevatorHologramService.updateElevatorHologram(elevator);
        if (!elevator.getElevatorType(true).shouldAllowIndividualEdit()) {
            return;
        }
        if (!ElevatorHookService.canEditElevator(player, elevator, true)) {
            return;
        }
        ElevatorGUIHelper.openInteractMenu(event.getPlayer(), elevator);
    }

    public static void onElevatorPlace(Elevator elevator) {
    }

    public static void onElevatorUse(Player player, ElevatorEventData elevatorEventData) {
        List<ElevatorAction> actions = elevatorEventData.getDirection() == 1 ? elevatorEventData.getOrigin().getElevatorType().getActionsUp() : elevatorEventData.getOrigin().getElevatorType().getActionsDown();
        if (actions.stream().anyMatch(action -> !action.meetsConditions(elevatorEventData, player))) {
            return;
        }
        ElevatorUseEvent useEvent = new ElevatorUseEvent(player, elevatorEventData);
        Bukkit.getPluginManager().callEvent((Event)useEvent);
        if (useEvent.isCancelled()) {
            return;
        }
        actions.forEach(action -> action.execute(elevatorEventData, player));
        Location teleportLocation = player.getLocation();
        teleportLocation.setY((double)elevatorEventData.getDestination().getLocation().getBlockY() + elevatorEventData.getStandOnAddition() + 1.0);
        Elevators.getFoliaLib().getScheduler().teleportAsync((Entity)player, teleportLocation);
    }

    public static boolean hasOrAddPlayerCoolDown(Player player, String key) {
        if (player.hasMetadata((String)(key = "elevator-cooldown-" + (String)key))) {
            MetadataValue value = (MetadataValue)player.getMetadata((String)key).get(0);
            long lastTime = value.asLong();
            if (System.currentTimeMillis() - lastTime < 1000L) {
                return true;
            }
            player.removeMetadata((String)key, (Plugin)Elevators.getInstance());
        }
        player.setMetadata((String)key, (MetadataValue)new FixedMetadataValue((Plugin)Elevators.getInstance(), (Object)System.currentTimeMillis()));
        return false;
    }

    public static boolean isElevatorDisabled(ShulkerBox shulkerBox) {
        return shulkerBox.hasMetadata("elevator-disabled");
    }
}

