/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.events;

import com.zetaplugins.zetacore.annotations.AutoRegisterListener;
import com.zetaplugins.zetacore.libs.reflections.Reflections;
import com.zetaplugins.zetacore.libs.reflections.scanners.Scanner;
import com.zetaplugins.zetacore.services.events.EventRegistrar;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AutoEventRegistrar
implements EventRegistrar {
    private final JavaPlugin plugin;
    private final String packagePrefix;

    public AutoEventRegistrar(JavaPlugin plugin, String packagePrefix) {
        this.plugin = plugin;
        this.packagePrefix = packagePrefix;
    }

    @Override
    public List<String> registerAllListeners() {
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegisterListener.class);
        ArrayList<String> registeredListeners = new ArrayList<String>();
        for (Class<?> clazz : annotatedClasses) {
            String listenerName;
            if (!Listener.class.isAssignableFrom(clazz) || (listenerName = this.registerListener(clazz)) == null) continue;
            registeredListeners.add(listenerName);
        }
        registeredListeners.sort(String::compareTo);
        return registeredListeners;
    }

    private String registerListener(Class<?> listenerClass) {
        try {
            Listener listener;
            try {
                Constructor<?> constructor = listenerClass.getConstructor(this.plugin.getClass());
                listener = (Listener)constructor.newInstance(this.plugin);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constructor = listenerClass.getConstructor(new Class[0]);
                listener = (Listener)constructor.newInstance(new Object[0]);
            }
            this.plugin.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
            AutoRegisterListener annotation = listenerClass.getAnnotation(AutoRegisterListener.class);
            return annotation.name().isEmpty() ? listenerClass.getSimpleName() : annotation.name();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to register listener: " + listenerClass.getSimpleName(), e);
            return null;
        }
    }

    @Override
    public void registerListener(Listener ... listener) {
        for (Listener l : listener) {
            if (l == null) continue;
            this.plugin.getServer().getPluginManager().registerEvents(l, (Plugin)this.plugin);
        }
    }
}

