/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.debug.command;

import com.zetaplugins.zetacore.debug.ReportDataCollector;
import com.zetaplugins.zetacore.debug.ReportFileWriter;
import com.zetaplugins.zetacore.debug.command.DebugCommandMessages;
import com.zetaplugins.zetacore.debug.data.DebugReport;
import com.zetaplugins.zetacore.debug.uploader.ZetaDebugReportUploader;
import com.zetaplugins.zetacore.services.messages.Messenger;
import com.zetaplugins.zetacore.services.messages.Replaceable;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugCommandHandler
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final File pluginFile;
    private final String permission;
    private final DebugCommandMessages messages;
    private final String modrinthId;
    private final Map<String, String> configs;
    private final Messenger messenger;

    public DebugCommandHandler(String modrinthId, JavaPlugin plugin, File pluginFile, String permission, Messenger messenger) {
        this(modrinthId, plugin, pluginFile, permission, null, new DebugCommandMessages(), messenger);
    }

    public DebugCommandHandler(String modrinthId, JavaPlugin plugin, File pluginFile, String permission, Map<String, String> configs, Messenger messenger) {
        this(modrinthId, plugin, pluginFile, permission, configs, new DebugCommandMessages(), messenger);
    }

    public DebugCommandHandler(String modrinthId, JavaPlugin plugin, File pluginFile, String permission, Map<String, String> configs, DebugCommandMessages messages, Messenger messenger) {
        this.plugin = plugin;
        this.pluginFile = pluginFile;
        this.permission = permission;
        this.messages = messages;
        this.modrinthId = modrinthId;
        this.configs = configs;
        this.messenger = messenger;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.throwUsageError(sender, this.messages.usageMessage(), command.getName());
            return true;
        }
        return switch (subCommand = args[0].toLowerCase()) {
            case "upload" -> {
                if (!sender.hasPermission(this.permission)) {
                    this.throwPermissionError(sender);
                    yield true;
                }
                yield this.handleUpload(sender, args.length > 1 && args[1].equalsIgnoreCase("confirm"), command.getName());
            }
            case "generate" -> {
                if (!sender.hasPermission(this.permission)) {
                    this.throwPermissionError(sender);
                    yield true;
                }
                yield this.handleGenerate(sender);
            }
            default -> {
                this.throwUsageError(sender, this.messages.usageMessage(), command.getName());
                yield true;
            }
        };
    }

    private void throwUsageError(@NotNull CommandSender sender, String usage, String commandName) {
        this.messenger.sendRaw(sender, usage, new Replaceable<String>("%command%", commandName));
    }

    private void throwPermissionError(@NotNull CommandSender sender) {
        this.messenger.sendRaw(sender, this.messages.noPermissionMessage(), new Replaceable[0]);
    }

    private boolean handleUpload(CommandSender sender, boolean confirmed, String commandName) {
        if (!confirmed) {
            this.messenger.sendRaw(sender, this.messages.uploadConfirmMessage(), new Replaceable<CallSite>("%command%", (CallSite)((Object)("/" + commandName + " upload confirm"))));
            return true;
        }
        if (!sender.hasPermission(this.permission)) {
            this.throwPermissionError(sender);
            return true;
        }
        DebugReport report = ReportDataCollector.collect(this.modrinthId, this.plugin, this.pluginFile, this.configs);
        String url = ZetaDebugReportUploader.uploadReport(report, this.plugin);
        if (url == null) {
            this.messenger.sendRaw(sender, this.messages.failToUploadMessage(), new Replaceable<String>("%error%", "Failed to upload report."));
            return false;
        }
        String formattedUrl = url.replaceAll("\\\\", "");
        this.messenger.sendRaw(sender, this.messages.uploadSuccessMessage(), new Replaceable<String>("%url%", formattedUrl));
        return true;
    }

    private boolean handleGenerate(CommandSender sender) {
        DebugReport report = ReportDataCollector.collect(this.modrinthId, this.plugin, this.pluginFile, this.configs);
        File reportJson = new File("debug-report.json");
        File reportTxt = new File("debug-report.txt");
        try {
            ReportFileWriter.writeJsonReportToFile(report, reportJson);
            ReportFileWriter.writeTextReportToFile(report, reportTxt);
        }
        catch (IOException e) {
            this.messenger.sendRaw(sender, this.messages.failedToCreateFileMessage(), new Replaceable<String>("%error%", e.getMessage()));
            this.plugin.getLogger().log(Level.SEVERE, "Failed to write debug report", e);
            return false;
        }
        this.messenger.sendRaw(sender, this.messages.fileCreateSuccessMessage(), new Replaceable<String>("%jsonPath%", reportJson.getAbsolutePath()), new Replaceable<String>("%txtPath%", reportTxt.getAbsolutePath()));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return List.of("upload", "generate");
        }
        return null;
    }
}

