/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.debug;

import com.zetaplugins.zetacore.debug.data.DebugReport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.function.Function;

public final class ReportFileWriter {
    private ReportFileWriter() {
    }

    public static void writeJsonReportToFile(DebugReport report, File file) throws IOException {
        ReportFileWriter.writeReportToFile(report, file, DebugReport::toJsonString);
    }

    public static void writeTextReportToFile(DebugReport report, File file) throws IOException {
        ReportFileWriter.writeReportToFile(report, file, DebugReport::toReadableText);
    }

    private static void writeReportToFile(DebugReport report, File file, Function<DebugReport, String> formatter) throws IOException {
        if (report == null) {
            throw new IllegalArgumentException("DebugReport cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directories for file: " + file.getPath());
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(formatter.apply(report));
        }
    }
}

