/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.commands;

import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterTabCompleter;
import com.zetaplugins.zetacore.libs.reflections.Reflections;
import com.zetaplugins.zetacore.libs.reflections.scanners.Scanner;
import com.zetaplugins.zetacore.services.commands.CommandRegistrar;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public class AutoCommandRegistrar
implements CommandRegistrar {
    private final JavaPlugin plugin;
    private final String packagePrefix;

    public AutoCommandRegistrar(JavaPlugin plugin, String packagePrefix) {
        this.plugin = plugin;
        this.packagePrefix = packagePrefix;
    }

    @Override
    public List<String> registerAllCommands() {
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        ArrayList<String> registeredCommands = new ArrayList<String>();
        HashMap<String, TabCompleter> tabCompleters = new HashMap<String, TabCompleter>();
        Set<Class<?>> tabCompleterClasses = reflections.getTypesAnnotatedWith(AutoRegisterTabCompleter.class);
        for (Class<?> clazz : tabCompleterClasses) {
            if (!TabCompleter.class.isAssignableFrom(clazz)) continue;
            AutoRegisterTabCompleter annotation = clazz.getAnnotation(AutoRegisterTabCompleter.class);
            TabCompleter completer = this.createTabCompleter(clazz);
            if (completer == null) continue;
            tabCompleters.put(annotation.command(), completer);
        }
        Set<Class<?>> commandClasses = reflections.getTypesAnnotatedWith(AutoRegisterCommand.class);
        for (Class<?> clazz : commandClasses) {
            String commandName;
            if (!CommandExecutor.class.isAssignableFrom(clazz) || (commandName = this.registerCommand(clazz, tabCompleters)) == null) continue;
            registeredCommands.add(commandName);
        }
        registeredCommands.sort(String::compareTo);
        return registeredCommands;
    }

    private TabCompleter createTabCompleter(Class<?> completerClass) {
        try {
            try {
                Constructor<?> constructor = completerClass.getConstructor(this.plugin.getClass());
                return (TabCompleter)constructor.newInstance(this.plugin);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constructor = completerClass.getConstructor(new Class[0]);
                return (TabCompleter)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create tab completer: " + completerClass.getSimpleName(), e);
            return null;
        }
    }

    private String registerCommand(Class<?> commandClass, Map<String, TabCompleter> tabCompleters) {
        try {
            CommandExecutor executor;
            AutoRegisterCommand annotation = commandClass.getAnnotation(AutoRegisterCommand.class);
            String commandName = annotation.command();
            try {
                Constructor<?> constructor = commandClass.getConstructor(this.plugin.getClass());
                executor = (CommandExecutor)constructor.newInstance(this.plugin);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constructor = commandClass.getConstructor(new Class[0]);
                executor = (CommandExecutor)constructor.newInstance(new Object[0]);
            }
            PluginCommand command = this.plugin.getCommand(commandName);
            if (command != null) {
                command.setExecutor(executor);
                if (executor instanceof TabCompleter) {
                    command.setTabCompleter((TabCompleter)executor);
                } else if (tabCompleters.containsKey(commandName)) {
                    command.setTabCompleter(tabCompleters.get(commandName));
                }
                return annotation.name().isEmpty() ? commandClass.getSimpleName() : annotation.name();
            }
            this.plugin.getLogger().warning("Command '" + commandName + "' not found in plugin.yml");
            return null;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to register command: " + commandClass.getSimpleName(), e);
            return null;
        }
    }

    @Override
    public void registerCommand(String name, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand command = this.plugin.getCommand(name);
        if (command != null) {
            command.setExecutor(executor);
            if (tabCompleter != null) {
                command.setTabCompleter(tabCompleter);
            }
        }
    }
}

