/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.messages;

import com.zetaplugins.zetacore.services.localization.LocalizationService;
import com.zetaplugins.zetacore.services.messages.BaseMessageService;
import com.zetaplugins.zetacore.services.messages.Messenger;
import com.zetaplugins.zetacore.services.messages.Replaceable;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;

public class AdventureMessenger
extends BaseMessageService
implements Messenger {
    private final MiniMessage mm = MiniMessage.miniMessage();

    public AdventureMessenger(LocalizationService localizationService) {
        super(localizationService);
    }

    @Override
    public void send(CommandSender player, boolean addPrefix, String path, String fallback, Replaceable<?> ... replaceables) {
        String raw = this.getRawMessage(path, fallback, addPrefix);
        String processed = this.replacePlaceholdersWithAccentColors("<!i>" + raw, replaceables);
        Component comp = this.mm.deserialize((Object)processed);
        player.sendMessage(comp);
    }

    @Override
    public void sendRaw(CommandSender player, String rawMessage, Replaceable<?> ... replaceables) {
        String processed = this.replacePlaceholdersWithAccentColors("<!i>" + rawMessage, replaceables);
        Component comp = this.mm.deserialize((Object)processed);
        player.sendMessage(comp);
    }

    @Override
    public void sendList(CommandSender player, String path, Replaceable<?> ... replaceables) {
        List<String> rawList = this.getRawMessageList(path);
        for (String item : rawList) {
            String processed = this.replacePlaceholdersWithAccentColors("<!i>" + item, replaceables);
            player.sendMessage(this.mm.deserialize((Object)processed));
        }
    }
}

