/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.lifestealz.commands.MainCommand.subcommands;

import com.zetaplugins.lifestealz.LifeStealZ;
import com.zetaplugins.lifestealz.commands.SubCommand;
import com.zetaplugins.lifestealz.util.MessageUtils;
import com.zetaplugins.lifestealz.util.commands.CommandUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public final class DebugSubCommand
implements SubCommand {
    private final LifeStealZ plugin;

    public DebugSubCommand(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender)) {
            CommandUtils.throwPermissionError(sender);
            return false;
        }
        sender.sendMessage(MessageUtils.getAndFormatMsg(false, "generatingDebugReport", "&7Generating debug report...", new MessageUtils.Replaceable[0]));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String debugDump = this.generateDebugDump();
                String pasteUrl = this.uploadToMclogs(debugDump);
                if (pasteUrl != null) {
                    pasteUrl = pasteUrl.replace("\\/", "/");
                    Component message = MessageUtils.getAndFormatMsg(false, "debugReportUploaded", "&aDebug report uploaded: ", new MessageUtils.Replaceable[0]).append(MessageUtils.formatMsg("&7" + pasteUrl, new MessageUtils.Replaceable[0]).clickEvent(ClickEvent.openUrl((String)pasteUrl)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.getAndFormatMsg(false, "clickToOpenDebugReport", "&eClick to open the debug report", new MessageUtils.Replaceable[0]))));
                    sender.sendMessage(message);
                } else {
                    sender.sendMessage(MessageUtils.getAndFormatMsg(false, "failedToUploadDebugReport", "&cFailed to upload debug report. Please try again later.", new MessageUtils.Replaceable[0]));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error generating debug report", e);
                sender.sendMessage(MessageUtils.getAndFormatMsg(false, "errorWhileGeneratingDebugReport", "&cAn error occurred while generating the debug report.", new MessageUtils.Replaceable[0]));
            }
        });
        return true;
    }

    @Override
    public String getUsage() {
        return "/lifestealz debug";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp() || sender.equals((Object)Bukkit.getConsoleSender());
    }

    private String generateDebugDump() {
        StringBuilder debug = new StringBuilder();
        long epochTime = System.currentTimeMillis();
        String formattedTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(epochTime));
        String pluginVersion = this.plugin.getDescription().getVersion();
        String pluginHash = this.generatePluginHash();
        String serverVersion = Bukkit.getVersion();
        String serverSoftware = Bukkit.getName();
        String javaVersion = System.getProperty("java.version");
        String osInfo = System.getProperty("os.name") + " " + System.getProperty("os.version");
        debug.append("---- LifeStealZ Debug Dump ----\n").append("// This is an automatically generated debug report for the LifeStealZ Plugin.\n").append("// This report DOES NOT include any Personally Identifiable Information.\n").append("// This debug report is intended to be provided to a support agent.\n\n").append("// For More Information visit: https://modrinth.com/plugin/lifestealz\n\n").append("Time: ").append(formattedTime).append(" (Epoch: ").append(epochTime).append(")\n\n");
        debug.append("-- Plugin Details --\n").append("Plugin Version: ").append(pluginVersion).append("\n").append("Plugin Hash: ").append(pluginHash).append("\n\n").append("Minecraft Version: ").append(serverVersion).append("\n").append("Server Software: ").append(serverSoftware).append("\n").append("Java Version: ").append(javaVersion).append("\n").append("OS: ").append(osInfo).append("\n\n");
        debug.append("-- Installed Plugins --\n").append(this.getInstalledPlugins()).append("\n\n");
        debug.append("-- Lifecycle Logs --\n").append(this.getPluginLogs()).append("\n\n");
        debug.append("-- Configuration Files --\n");
        debug.append("# config.yml\n```yaml\n").append(this.plugin.getConfig().saveToString()).append("\n```\n\n");
        debug.append("# storage.yml\n```yaml\n").append(this.plugin.getConfigManager().getStorageConfig().saveToString()).append("\n```\n\n");
        debug.append("# items.yml\n```yaml\n").append(this.plugin.getConfigManager().getCustomItemConfig().saveToString()).append("\n```\n\n");
        return debug.toString();
    }

    private String getPluginLogs() {
        StringBuilder logContent = new StringBuilder();
        try {
            File logFile = new File("logs/latest.log");
            if (!logFile.exists()) {
                File serverDir = new File(".");
                Optional<File> latestLog = Arrays.stream(serverDir.listFiles()).filter(f -> f.isFile() && f.getName().endsWith(".log")).max(Comparator.comparingLong(File::lastModified));
                if (latestLog.isPresent()) {
                    logFile = latestLog.get();
                } else {
                    return "Could not find server log file.";
                }
            }
            String pluginName = this.plugin.getDescription().getName();
            Pattern logPattern = Pattern.compile(".*\\[(.*" + pluginName + ".*)\\].*");
            int linesAdded = 0;
            int maxLines = 500;
            List<String> logLines = Files.readAllLines(logFile.toPath());
            for (int i = logLines.size() - 1; i >= 0 && linesAdded < maxLines; --i) {
                String line = logLines.get(i);
                Matcher matcher = logPattern.matcher(line);
                if (matcher.matches() || line.contains(pluginName)) {
                    logContent.append(line).append("\n");
                    ++linesAdded;
                }
                if (!line.contains("ERROR") && !line.contains("Exception") && !line.contains("Error:")) continue;
                boolean isRelated = false;
                for (int j = Math.max(0, i - 5); j < Math.min(logLines.size(), i + 5); ++j) {
                    if (!logLines.get(j).contains(pluginName)) continue;
                    isRelated = true;
                    break;
                }
                if (!isRelated) continue;
                logContent.insert(3, line + "\n");
                ++linesAdded;
            }
            if (linesAdded >= maxLines) {
                logContent.insert(3, "// Note: Log output limited to " + maxLines + " lines (most recent first)\n");
            }
        }
        catch (IOException e) {
            logContent.append("Failed to read log file: ").append(e.getMessage());
        }
        return logContent.toString();
    }

    private String generatePluginHash() {
        try {
            File pluginFile = this.plugin.getPluginFile();
            if (pluginFile == null || !pluginFile.exists()) {
                return "UNKNOWN";
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream fis = new FileInputStream(pluginFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            byte[] hashBytes = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte hashByte : hashBytes) {
                hexString.append(String.format("%02x", hashByte));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to generate plugin hash", e);
            return "ERROR";
        }
    }

    private String getInstalledPlugins() {
        StringBuilder pluginInfo = new StringBuilder();
        for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
            pluginInfo.append("- ").append(p.getName()).append(" v").append(p.getDescription().getVersion()).append(" (Enabled: ").append(p.isEnabled()).append(")").append("\n");
        }
        return pluginInfo.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String uploadToMclogs(String content) {
        try {
            URL url = new URL("https://api.mclo.gs/1/log");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("User-Agent", "LifeStealZ/" + this.plugin.getDescription().getVersion());
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            String encodedContent = "content=" + URLEncoder.encode(content, StandardCharsets.UTF_8);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = encodedContent.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                this.plugin.getLogger().warning("Failed to upload to mclo.gs. Response code: " + responseCode);
                return null;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine);
                }
                String string = this.parseMclogsResponse(response.toString());
                return string;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to upload debug report", e);
        }
        return null;
    }

    private String parseMclogsResponse(String jsonResponse) {
        if (jsonResponse.contains("\"success\":true") && jsonResponse.contains("\"url\":\"")) {
            int urlStart = jsonResponse.indexOf("\"url\":\"") + 7;
            int urlEnd = jsonResponse.indexOf("\"", urlStart);
            return jsonResponse.substring(urlStart, urlEnd);
        }
        this.plugin.getLogger().warning("Invalid response from mclo.gs: " + jsonResponse);
        return null;
    }
}

