/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.lifestealz.util.customblocks;

import com.zetaplugins.lifestealz.LifeStealZ;
import com.zetaplugins.lifestealz.util.customblocks.ParticleColor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class ReviveBeaconEffectManager {
    private final LifeStealZ plugin;
    private final Map<Location, BukkitTask> idleParticleBeacons;
    private final Map<Location, BukkitTask> revivingParticleBeacons;
    private final Map<Location, Set<BlockDisplay>> lasers;
    private final Map<Location, BukkitTask> laserGrowTasks;
    private final Map<Location, BlockDisplay> decoyDisplays;

    public ReviveBeaconEffectManager(LifeStealZ plugin) {
        this.plugin = plugin;
        this.idleParticleBeacons = new HashMap<Location, BukkitTask>();
        this.revivingParticleBeacons = new HashMap<Location, BukkitTask>();
        this.lasers = new HashMap<Location, Set<BlockDisplay>>();
        this.laserGrowTasks = new HashMap<Location, BukkitTask>();
        this.decoyDisplays = new HashMap<Location, BlockDisplay>();
    }

    public void startIdleEffects(final Location location, boolean showEnchantParticles, Material decoyMaterial) {
        if (this.idleParticleBeacons.containsKey(this.getKey(location)) || this.decoyDisplays.containsKey(this.getKey(location))) {
            return;
        }
        this.applyMaterialDecoy(location, decoyMaterial);
        if (!showEnchantParticles) {
            return;
        }
        BukkitTask runnable = new BukkitRunnable(){
            final Location center;
            {
                this.center = location.clone().add(0.5, 1.0, 0.5);
            }

            public void run() {
                this.center.getWorld().spawnParticle(Particle.ENCHANT, this.center, 25, 0.6, 0.5, 0.6, 0.0);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
        this.idleParticleBeacons.put(this.getKey(location), runnable);
    }

    public void startRevivingEffects(final Location location, final String target, boolean showLaser, boolean showParticleRing, final ParticleColor particleColor, Material innerLaserMaterial, Material outerLaserMaterial, int reviveTime) {
        if (this.revivingParticleBeacons.containsKey(location) || this.lasers.containsKey(location)) {
            return;
        }
        if (showLaser) {
            this.spawnBeaconLaser(location, innerLaserMaterial, outerLaserMaterial);
        }
        location.getWorld().playSound(location, Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
        if (showParticleRing) {
            BukkitTask runnable = new BukkitRunnable(){
                final Location center;
                {
                    this.center = location.clone().add(0.5, 1.0, 0.5);
                }

                public void run() {
                    ReviveBeaconEffectManager.this.spawnRing(this.center, particleColor);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
            this.revivingParticleBeacons.put(this.getKey(location), runnable);
        }
        if (!this.plugin.getConfig().getBoolean("showBossbar")) {
            return;
        }
        final int countdown = reviveTime;
        final BossBar bossBar = Bukkit.createBossBar((String)"", (BarColor)this.parseBarColor(this.plugin.getConfig().getString("bossbarColor").toUpperCase(), BarColor.RED), (BarStyle)this.parseBarStyle(this.plugin.getConfig().getString("bossbarStyle").toUpperCase(), BarStyle.SOLID), (BarFlag[])new BarFlag[0]);
        bossBar.setVisible(true);
        new BukkitRunnable(){
            int timeleft;
            {
                this.timeleft = countdown;
            }

            public void run() {
                if (this.timeleft <= 0) {
                    bossBar.setVisible(false);
                    bossBar.removeAll();
                    this.cancel();
                    return;
                }
                int days = this.timeleft / 86400;
                int hours = this.timeleft % 86400 / 3600;
                int minutes = (this.timeleft & 0xE10) / 60;
                int seconds = this.timeleft % 60;
                String hFormatted = String.format("%02d", hours);
                String mFormatted = String.format("%02d", minutes);
                String sFormatted = String.format("%02d", seconds);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    bossBar.addPlayer(p);
                }
                bossBar.setProgress((double)this.timeleft / (double)countdown);
                String title = ReviveBeaconEffectManager.this.plugin.getLanguageManager().getString("reviveBossbarTitle").replace("&target&", target).replace("&remainingD&", String.valueOf(days)).replace("&remainingH&", hFormatted).replace("&remainingM&", mFormatted).replace("&remainingS&", sFormatted).replace("&locationX&", String.valueOf(location.getBlockX())).replace("&locationY&", String.valueOf(location.getBlockY())).replace("&locationZ&", String.valueOf(location.getBlockZ())).replace("&location&", location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ());
                bossBar.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)title));
                --this.timeleft;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void applyMaterialDecoy(Location location, Material decoyMaterial) {
        if (this.decoyDisplays.containsKey(this.getKey(location))) {
            return;
        }
        BlockDisplay display = (BlockDisplay)location.getWorld().spawn(location, BlockDisplay.class);
        display.setBlock(decoyMaterial.createBlockData());
        display.setPersistent(true);
        display.setBrightness(new Display.Brightness(8, 8));
        this.decoyDisplays.put(this.getKey(location), display);
        this.animateDecoyGrowth(display);
    }

    private void animateDecoyGrowth(final BlockDisplay display) {
        float targetSize = 1.01f;
        float initialHeight = 0.0f;
        float width = 1.01f;
        long tickInterval = 1L;
        float growSpeed = 0.25f;
        display.setTransformation(new Transformation(new Vector3f(-0.004999995f, 0.5f, -0.004999995f), new Quaternionf(), new Vector3f(1.01f, 0.0f, 1.01f), new Quaternionf()));
        new BukkitRunnable(){
            float currentHeight = 0.0f;

            public void run() {
                this.currentHeight += 0.25f;
                if (this.currentHeight >= 1.01f) {
                    this.currentHeight = 1.01f;
                    this.cancel();
                }
                float translationY = 0.5f - this.currentHeight / 2.0f;
                display.setTransformation(new Transformation(new Vector3f(-0.004999995f, translationY, -0.004999995f), new Quaternionf(), new Vector3f(1.01f, this.currentHeight, 1.01f), new Quaternionf()));
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void spawnVerticalParticleBeam(Location center) {
        int height = 15;
        for (double y = 0.0; y < 15.0; y += 0.5) {
            center.getWorld().spawnParticle(Particle.DUST, center.clone().add(0.0, y, 0.0), 1, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(ParticleColor.RED.getColor(), 1.5f));
        }
    }

    private void spawnRing(Location center, ParticleColor particleColor) {
        double radius = 1.5;
        int points = 25;
        Location ringCenter = center.clone().add(0.0, -0.5, 0.0);
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            center.getWorld().spawnParticle(Particle.DUST, ringCenter.clone().add(xOffset, 0.25, zOffset), 1, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(particleColor.getColor(), 1.2f));
        }
    }

    private void spawnBeaconLaser(Location location, Material innerMaterial, Material outerMaterial) {
        float finalHeight = 150.0f;
        float width1 = 0.3f;
        float width2 = 0.5f;
        float growSpeed = 1.0f;
        Location quartzLoc = location.clone().add((double)0.35f, 0.0, (double)0.35f);
        Location glassLoc = location.clone().add(0.25, 0.0, 0.25);
        final BlockDisplay quartz = (BlockDisplay)location.getWorld().spawn(quartzLoc, BlockDisplay.class);
        quartz.setBlock(innerMaterial.createBlockData());
        quartz.setPersistent(true);
        final BlockDisplay glass = (BlockDisplay)location.getWorld().spawn(glassLoc, BlockDisplay.class);
        glass.setBlock(outerMaterial.createBlockData());
        glass.setPersistent(true);
        this.lasers.put(this.getKey(location), Set.of(quartz, glass));
        Vector3f initialQuartzScale = new Vector3f(0.3f, 0.1f, 0.3f);
        Vector3f initialGlassScale = new Vector3f(0.5f, 0.1f, 0.5f);
        final Quaternionf noRotation = new Quaternionf();
        final Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
        quartz.setTransformation(new Transformation(translation, noRotation, initialQuartzScale, noRotation));
        glass.setTransformation(new Transformation(translation, noRotation, initialGlassScale, noRotation));
        BukkitTask lasergrowTask = new BukkitRunnable(){
            float currentHeight = 0.1f;

            public void run() {
                this.currentHeight += 1.0f;
                if (this.currentHeight >= 150.0f) {
                    this.currentHeight = 150.0f;
                    this.cancel();
                }
                quartz.setTransformation(new Transformation(translation, noRotation, new Vector3f(0.3f, this.currentHeight, 0.3f), noRotation));
                glass.setTransformation(new Transformation(translation, noRotation, new Vector3f(0.5f, this.currentHeight, 0.5f), noRotation));
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        this.laserGrowTasks.put(this.getKey(location), lasergrowTask);
    }

    public void stopIdlePArticles(Location location) {
        BukkitTask task = this.idleParticleBeacons.remove(this.getKey(location));
        if (task != null) {
            task.cancel();
        }
    }

    public void stopRevivingParticles(Location location) {
        BukkitTask task = this.revivingParticleBeacons.remove(this.getKey(location));
        if (task != null) {
            task.cancel();
        }
    }

    public void removeLaser(Location location) {
        Set<BlockDisplay> displays;
        Location key = this.getKey(location);
        BukkitTask growTask = this.laserGrowTasks.remove(key);
        if (growTask != null) {
            growTask.cancel();
        }
        if ((displays = this.lasers.remove(key)) == null || displays.isEmpty()) {
            return;
        }
        float collapseSpeed = 1.0f;
        new BukkitRunnable(){
            float currentHeight;
            final float initialHeight;
            {
                this.initialHeight = this.currentHeight = displays.stream().findFirst().map(d -> Float.valueOf(d.getTransformation().getScale().y)).orElse(Float.valueOf(150.0f)).floatValue();
            }

            public void run() {
                this.currentHeight -= 1.0f;
                if (this.currentHeight <= 0.0f) {
                    for (BlockDisplay display : displays) {
                        if (display == null) continue;
                        display.remove();
                    }
                    this.cancel();
                    return;
                }
                for (BlockDisplay display : displays) {
                    if (display == null) continue;
                    Vector3f originalScale = display.getTransformation().getScale();
                    float width = originalScale.x;
                    float yTranslation = (this.initialHeight - this.currentHeight) / 2.0f;
                    display.setTransformation(new Transformation(new Vector3f(0.0f, yTranslation, 0.0f), new Quaternionf(), new Vector3f(width, this.currentHeight, width), new Quaternionf()));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void removeDecoy(Location location) {
        BlockDisplay display = this.decoyDisplays.remove(this.getKey(location));
        if (display != null) {
            display.remove();
        }
    }

    public void clearAllEffects(Location location) {
        this.stopIdlePArticles(location);
        this.stopRevivingParticles(location);
        this.removeLaser(location);
        this.removeDecoy(location);
    }

    public void clearAllEffects() {
        for (BukkitTask bukkitTask : this.idleParticleBeacons.values()) {
            bukkitTask.cancel();
        }
        this.idleParticleBeacons.clear();
        for (BukkitTask bukkitTask : this.revivingParticleBeacons.values()) {
            bukkitTask.cancel();
        }
        this.revivingParticleBeacons.clear();
        for (Set set : this.lasers.values()) {
            if (set == null) continue;
            for (BlockDisplay display : set) {
                if (display == null) continue;
                display.remove();
            }
        }
        this.lasers.clear();
        for (BukkitTask bukkitTask : this.laserGrowTasks.values()) {
            bukkitTask.cancel();
        }
        this.laserGrowTasks.clear();
        for (BlockDisplay blockDisplay : this.decoyDisplays.values()) {
            if (blockDisplay == null) continue;
            blockDisplay.remove();
        }
        this.decoyDisplays.clear();
    }

    private Location getKey(Location location) {
        return new Location(location.getWorld(), (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
    }

    private BarColor parseBarColor(String color, BarColor fallbackColor) {
        BarColor barColor = BarColor.valueOf((String)color.toUpperCase());
        return barColor != null ? barColor : fallbackColor;
    }

    private BarStyle parseBarStyle(String style, BarStyle fallbackStyle) {
        BarStyle barStyle = BarStyle.valueOf((String)style.toUpperCase());
        return barStyle != null ? barStyle : fallbackStyle;
    }
}

