/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.lifestealz.util;

import com.zetaplugins.lifestealz.LifeStealZ;
import com.zetaplugins.lifestealz.util.MessageUtils;
import com.zetaplugins.lifestealz.util.customitems.CustomItem;
import com.zetaplugins.lifestealz.util.customitems.CustomItemManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class GuiManager {
    public static Map<UUID, Inventory> REVIVE_GUI_MAP = new HashMap<UUID, Inventory>();
    public static Map<UUID, Inventory> REVIVE_BEACON_GUI_MAP = new HashMap<UUID, Inventory>();
    public static Map<UUID, Inventory> RECIPE_GUI_MAP = new HashMap<UUID, Inventory>();
    public static Map<UUID, Location> REVIVE_BEACON_INVENTORY_LOCATIONS = new HashMap<UUID, Location>();

    private GuiManager() {
    }

    public static void openReviveGui(Player player, int page) {
        List<UUID> eliminatedPlayers = LifeStealZ.getInstance().getStorage().getEliminatedPlayers();
        Inventory inventory = GuiManager.getReviveInventory(eliminatedPlayers, page, LifeStealZ.getInstance());
        player.openInventory(inventory);
        REVIVE_GUI_MAP.put(player.getUniqueId(), inventory);
    }

    public static void openReviveBeaconGui(Player player, int page, LifeStealZ plugin, Location beaconLocation) {
        List<UUID> eliminatedPlayers = plugin.getStorage().getEliminatedPlayers();
        Inventory inventory = GuiManager.getReviveInventory(eliminatedPlayers, page, plugin);
        player.openInventory(inventory);
        REVIVE_BEACON_GUI_MAP.put(player.getUniqueId(), inventory);
        REVIVE_BEACON_INVENTORY_LOCATIONS.put(player.getUniqueId(), beaconLocation);
    }

    private static Inventory getReviveInventory(List<UUID> eliminatedPlayers, int page, LifeStealZ plugin) {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtils.getAndFormatMsg(false, "reviveTitle", "&8Revive a player", new MessageUtils.Replaceable[0]));
        int itemsPerPage = 45;
        if (page < 1) {
            page = 1;
        }
        int startIndex = (page - 1) * itemsPerPage;
        int endIndex = Math.min(page * itemsPerPage, eliminatedPlayers.size());
        for (int i = startIndex; i < endIndex; ++i) {
            UUID eliminatedPlayerUUID = eliminatedPlayers.get(i);
            if (eliminatedPlayerUUID == null) continue;
            if (plugin.hasGeyser() && plugin.getGeyserPlayerFile().isPlayerStored(eliminatedPlayerUUID)) {
                inventory.addItem(new ItemStack[]{new CustomItem(CustomItemManager.getBedrockPlayerHead(eliminatedPlayerUUID)).makeForbidden().getItemStack()});
                continue;
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)eliminatedPlayerUUID);
            inventory.addItem(new ItemStack[]{new CustomItem(CustomItemManager.getPlayerHead(offlinePlayer)).makeForbidden().getItemStack()});
        }
        GuiManager.addNavbar(inventory, page, page > 1, endIndex < eliminatedPlayers.size());
        return inventory;
    }

    private static void addNavbar(Inventory inventory, int page, boolean addBackButton, boolean addNextButton) {
        int[] glassSlots;
        inventory.setItem(49, CustomItemManager.createCloseItem());
        ItemStack glass = new CustomItem(Material.GRAY_STAINED_GLASS_PANE).setName("&r ").makeForbidden().getItemStack();
        for (int slot : glassSlots = new int[]{45, 47, 48, 50, 51, 53}) {
            inventory.setItem(slot, glass);
        }
        if (addBackButton) {
            inventory.setItem(46, CustomItemManager.createBackItem(page - 1));
        } else {
            inventory.setItem(46, glass);
        }
        if (addNextButton) {
            inventory.setItem(52, CustomItemManager.createNextItem(page + 1));
        } else {
            inventory.setItem(52, glass);
        }
    }
}

