/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.util.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.util.worldguard.HeartLossFlag;

public final class WorldGuardManager {
    private StateFlag HEARTLOSS_FLAG;

    public WorldGuardManager() {
        this.registerFlags();
    }

    private void registerFlags() {
        HeartLossFlag heartLossFlag = new HeartLossFlag();
        WorldGuard.getInstance().getFlagRegistry().register((Flag)heartLossFlag);
        this.HEARTLOSS_FLAG = heartLossFlag;
    }

    public StateFlag getHeartLossFlag() {
        return this.HEARTLOSS_FLAG;
    }

    public static boolean checkHeartLossFlag(Player player) {
        WorldGuardManager worldGuardManager = LifeStealZ.getInstance().getWorldGuardManager();
        if (worldGuardManager == null) {
            return false;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)player.getLocation());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(loc);
        return set.testState((RegionAssociable)localPlayer, new StateFlag[]{worldGuardManager.getHeartLossFlag()});
    }
}

