/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.util.geysermc;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.strassburger.lifestealz.LifeStealZ;

public class GeyserPlayerFile {
    private final JavaPlugin plugin = LifeStealZ.getInstance();
    private File geyserPlayerFile;
    private FileConfiguration geyserPlayerConfig;

    public GeyserPlayerFile() {
        this.createGeyserPlayerFile();
    }

    private void createGeyserPlayerFile() {
        this.geyserPlayerFile = new File(this.plugin.getDataFolder(), "geyser_players.yml");
        if (!this.geyserPlayerFile.exists()) {
            this.geyserPlayerFile.getParentFile().mkdirs();
            this.plugin.saveResource("geyser_players.yml", false);
        }
        this.geyserPlayerConfig = YamlConfiguration.loadConfiguration((File)this.geyserPlayerFile);
    }

    public void savePlayer(UUID uuid, String name) {
        this.geyserPlayerConfig.set("players." + uuid.toString() + ".name", (Object)name);
        this.saveConfig();
    }

    public String getPlayerName(UUID uuid) {
        return this.geyserPlayerConfig.getString("players." + uuid.toString() + ".name");
    }

    public UUID getPlayerUUID(String name) {
        if (name == null) {
            return null;
        }
        ConfigurationSection playersSection = this.geyserPlayerConfig.getConfigurationSection("players");
        if (playersSection == null) {
            return null;
        }
        Set keys = playersSection.getKeys(false);
        for (String uuidString : keys) {
            String storedName = this.geyserPlayerConfig.getString("players." + uuidString + ".name");
            if (storedName == null || !storedName.equalsIgnoreCase(name)) continue;
            return UUID.fromString(uuidString);
        }
        return null;
    }

    private void saveConfig() {
        try {
            this.geyserPlayerConfig.save(this.geyserPlayerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isPlayerStored(UUID uuid) {
        return this.geyserPlayerConfig.contains("players." + uuid.toString());
    }

    public boolean isPlayerStored(String name) {
        return this.getPlayerUUID(name) != null;
    }
}

