/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.util.customitems;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.util.MessageUtils;
import org.strassburger.lifestealz.util.customitems.CustomItem;
import org.strassburger.lifestealz.util.customitems.CustomItemData;

public final class CustomItemManager {
    public static final NamespacedKey CUSTOM_ITEM_ID_KEY = new NamespacedKey((Plugin)LifeStealZ.getInstance(), "customitemid");
    public static final NamespacedKey CUSTOM_ITEM_TYPE_KEY = new NamespacedKey((Plugin)LifeStealZ.getInstance(), "customitemtype");
    public static final NamespacedKey CUSTOM_HEART_VALUE_KEY = new NamespacedKey((Plugin)LifeStealZ.getInstance(), "customheartvalue");
    public static final NamespacedKey REVIVE_PAGE_KEY = new NamespacedKey((Plugin)LifeStealZ.getInstance(), "revivepage");
    public static final NamespacedKey DESPAWNABLE_KEY = new NamespacedKey((Plugin)LifeStealZ.getInstance(), "despawnable");
    public static final NamespacedKey INVULNERABLE_KEY = new NamespacedKey((Plugin)LifeStealZ.getInstance(), "invulnerable");

    private CustomItemManager() {
    }

    public static ItemStack createCustomItem(String itemId) {
        FileConfiguration config = LifeStealZ.getInstance().getConfigManager().getCustomItemConfig();
        CustomItem ci = new CustomItem(Material.valueOf((String)config.getString(itemId + ".material"))).setName(config.getString(itemId + ".name")).setLore(config.getStringList(itemId + ".lore")).setEnchanted(config.getBoolean(itemId + ".enchanted")).setInvulnerable(config.getBoolean(itemId + ".invulnerable")).setDespawnable(config.getBoolean(itemId + ".despawnable")).addFlag(ItemFlag.HIDE_ATTRIBUTES);
        ci.getItemStack().setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString("lifestealz_" + itemId).build()));
        ItemMeta itemMeta = ci.getItemStack().getItemMeta();
        itemMeta.getPersistentDataContainer().set(CUSTOM_ITEM_ID_KEY, PersistentDataType.STRING, (Object)itemId);
        String customItemType = config.getString(itemId + ".customItemType") != null ? Objects.requireNonNull(config.getString(itemId + ".customItemType")) : "heart";
        itemMeta.getPersistentDataContainer().set(CUSTOM_ITEM_TYPE_KEY, PersistentDataType.STRING, (Object)customItemType);
        if (customItemType.equalsIgnoreCase("heart")) {
            itemMeta.getPersistentDataContainer().set(CUSTOM_HEART_VALUE_KEY, PersistentDataType.INTEGER, (Object)config.getInt(itemId + ".customHeartValue"));
        }
        ci.getItemStack().setItemMeta(itemMeta);
        return ci.getItemStack();
    }

    public static ItemStack createCustomItem(String itemId, int amount) {
        return new CustomItem(CustomItemManager.createCustomItem(itemId)).setAmount(amount).getItemStack();
    }

    public static ItemStack createHeart() {
        return CustomItemManager.createCustomItem(LifeStealZ.getInstance().getConfig().getString("heartItem.default", "defaultheart"));
    }

    public static ItemStack createWithdrawHeart() {
        return CustomItemManager.createCustomItem(LifeStealZ.getInstance().getConfig().getString("heartItem.withdraw", "defaultheart"));
    }

    public static ItemStack createKillHeart() {
        return CustomItemManager.createCustomItem(LifeStealZ.getInstance().getConfig().getString("heartItem.kill", "defaultheart"));
    }

    public static ItemStack createNaturalDeathHeart() {
        return CustomItemManager.createCustomItem(LifeStealZ.getInstance().getConfig().getString("heartItem.naturalDeath", "defaultheart"));
    }

    public static ItemStack createHeartGainCooldownHeart() {
        return CustomItemManager.createCustomItem(LifeStealZ.getInstance().getConfig().getString("heartItem.heartGainCooldown", "defaultheart"));
    }

    public static ItemStack createMaxHealthHeart() {
        return CustomItemManager.createCustomItem(LifeStealZ.getInstance().getConfig().getString("heartItem.maxHearts", "defaultheart"));
    }

    public static ItemStack createCloseItem() {
        CustomItem ci = new CustomItem(Material.BARRIER).setName(MessageUtils.getAndFormatMsg(false, "closeBtn", "&cClose", new MessageUtils.Replaceable[0])).addFlag(ItemFlag.HIDE_ATTRIBUTES).makeForbidden();
        ci.getItemStack().setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString("lifestealz_close").build()));
        return ci.getItemStack();
    }

    public static ItemStack createBackItem(int page) {
        CustomItem ci = new CustomItem(Material.ARROW).setName(MessageUtils.getAndFormatMsg(false, "backBtn", "&cBack", new MessageUtils.Replaceable[0])).addFlag(ItemFlag.HIDE_ATTRIBUTES).makeForbidden();
        ci.getItemStack().setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString("lifestealz_back").build()));
        ItemMeta itemMeta = ci.getItemStack().getItemMeta();
        itemMeta.getPersistentDataContainer().set(REVIVE_PAGE_KEY, PersistentDataType.INTEGER, (Object)page);
        ci.getItemStack().setItemMeta(itemMeta);
        return ci.getItemStack();
    }

    public static ItemStack createNextItem(int page) {
        CustomItem ci = new CustomItem(Material.ARROW).setName(MessageUtils.getAndFormatMsg(false, "nextBtn", "&cNext", new MessageUtils.Replaceable[0])).addFlag(ItemFlag.HIDE_ATTRIBUTES).makeForbidden();
        ci.getItemStack().setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString("lifestealz_next").build()));
        ItemMeta itemMeta = ci.getItemStack().getItemMeta();
        itemMeta.getPersistentDataContainer().set(REVIVE_PAGE_KEY, PersistentDataType.INTEGER, (Object)page);
        ci.getItemStack().setItemMeta(itemMeta);
        return ci.getItemStack();
    }

    public static ItemStack createHeartAnimationTotem() {
        CustomItem ci = new CustomItem(Material.TOTEM_OF_UNDYING).setName(MessageUtils.getAndFormatMsg(false, "heartAnimationTotem", "&cHeart Animation", new MessageUtils.Replaceable[0])).setLore(new ArrayList<String>(List.of("&7This item is used for heart animations."))).addFlag(ItemFlag.HIDE_ATTRIBUTES).makeForbidden();
        ci.getItemStack().setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString("lifestealz_totem").build()));
        return ci.getItemStack();
    }

    public static boolean isHeartItem(ItemStack item) {
        return item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(CUSTOM_ITEM_TYPE_KEY, PersistentDataType.STRING) && ((String)item.getItemMeta().getPersistentDataContainer().get(CUSTOM_ITEM_TYPE_KEY, PersistentDataType.STRING)).equalsIgnoreCase("heart");
    }

    public static boolean isReviveItem(ItemStack item) {
        return item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(CUSTOM_ITEM_TYPE_KEY, PersistentDataType.STRING) && ((String)item.getItemMeta().getPersistentDataContainer().get(CUSTOM_ITEM_TYPE_KEY, PersistentDataType.STRING)).equalsIgnoreCase("revive");
    }

    public static boolean isForbiddenItem(ItemStack item) {
        return CustomItemManager.getCustomItemId(item) != null && CustomItemManager.getCustomItemId(item).equals("forbidden");
    }

    public static boolean isCustomItem(ItemStack item) {
        return CustomItemManager.getCustomItemId(item) != null;
    }

    public static boolean isNonUsableItem(ItemStack item) {
        return item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(CUSTOM_ITEM_TYPE_KEY, PersistentDataType.STRING) && ((String)item.getItemMeta().getPersistentDataContainer().get(CUSTOM_ITEM_TYPE_KEY, PersistentDataType.STRING)).equalsIgnoreCase("non-usable");
    }

    public static boolean isDespawnable(ItemStack item) {
        return item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(DESPAWNABLE_KEY, PersistentDataType.BOOLEAN) && (Boolean)item.getItemMeta().getPersistentDataContainer().get(DESPAWNABLE_KEY, PersistentDataType.BOOLEAN) != false;
    }

    public static boolean isInvulnerable(ItemStack item) {
        return item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(INVULNERABLE_KEY, PersistentDataType.BOOLEAN) && (Boolean)item.getItemMeta().getPersistentDataContainer().get(INVULNERABLE_KEY, PersistentDataType.BOOLEAN) != false;
    }

    @Nullable
    public static String getCustomItemId(ItemStack item) {
        if (item.getItemMeta() == null || !item.getItemMeta().getPersistentDataContainer().has(CUSTOM_ITEM_ID_KEY, PersistentDataType.STRING)) {
            return null;
        }
        return (String)item.getItemMeta().getPersistentDataContainer().get(CUSTOM_ITEM_ID_KEY, PersistentDataType.STRING);
    }

    public static ItemStack getPlayerHead(OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null || offlinePlayer.getName() == null) {
            return new CustomItem(Material.SKELETON_SKULL).setName("&dUnknown").setLore(new ArrayList<CallSite>(List.of("&8" + String.valueOf(UUID.randomUUID())))).getItemStack();
        }
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        skullMeta.displayName((Component)Component.text((String)("\u00a7d" + offlinePlayer.getName())));
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add(MessageUtils.getAndFormatMsg(false, "revivePlayerDesc", "&7Click to revive this player", new MessageUtils.Replaceable[0]));
        lines.add(MessageUtils.formatMsg("<dark_gray>" + String.valueOf(offlinePlayer.getUniqueId()), new MessageUtils.Replaceable[0]));
        skullMeta.lore(lines);
        skullMeta.setOwningPlayer(offlinePlayer);
        head.setItemMeta((ItemMeta)skullMeta);
        return head;
    }

    public static ItemStack getBedrockPlayerHead(UUID uuid) {
        ItemStack head = new ItemStack(Material.SKELETON_SKULL);
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        skullMeta.displayName((Component)Component.text((String)("\u00a7d" + LifeStealZ.getInstance().getGeyserManager().getOfflineBedrockPlayerName(uuid))));
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add(MessageUtils.getAndFormatMsg(false, "revivePlayerDesc", "&7Click to revive this player", new MessageUtils.Replaceable[0]));
        lines.add(MessageUtils.formatMsg("<dark_gray>" + String.valueOf(uuid), new MessageUtils.Replaceable[0]));
        lines.add(MessageUtils.formatMsg("<dark_gray><i>This player is using the Bedrock Edition of Minecraft.</i>", new MessageUtils.Replaceable[0]));
        skullMeta.lore(lines);
        head.setItemMeta((ItemMeta)skullMeta);
        return head;
    }

    public static CustomItemData getCustomItemData(String itemId) {
        try {
            return new CustomItemData(itemId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

