/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.util.customitems;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.strassburger.lifestealz.LifeStealZ;

public final class CustomItemData {
    private final String itemId;
    private final String name;
    private final List<String> lore;
    private final Material material;
    private final boolean enchanted;
    private final int customModelData;
    private final String customItemType;
    private final int customHeartValue;
    private final int minHearts;
    private final int maxHearts;
    private final boolean craftable;
    private final boolean requirePermission;
    private final boolean invulnerable;
    private final boolean despawnable;

    public CustomItemData(String itemId, String name, List<String> lore, Material material, boolean enchanted, int customModelData, String customItemType, int customHeartValue, int minHearts, int maxHearts, boolean craftable, boolean requirePermission, boolean invulnerable, boolean despawnable) {
        this.itemId = itemId;
        this.name = name;
        this.lore = lore;
        this.material = material;
        this.enchanted = enchanted;
        this.customModelData = customModelData;
        this.customItemType = customItemType;
        this.customHeartValue = customHeartValue;
        this.minHearts = minHearts;
        this.maxHearts = maxHearts;
        this.craftable = craftable;
        this.requirePermission = requirePermission;
        this.invulnerable = invulnerable;
        this.despawnable = despawnable;
    }

    public CustomItemData(String itemId) throws IllegalArgumentException {
        FileConfiguration config = LifeStealZ.getInstance().getConfigManager().getCustomItemConfig();
        ConfigurationSection section = config.getConfigurationSection(itemId);
        if (section == null) {
            throw new IllegalArgumentException("Custom item with id " + itemId + " does not exist!");
        }
        this.itemId = itemId;
        this.name = config.getString(itemId + ".name");
        this.lore = config.getStringList(itemId + ".lore");
        this.material = Material.valueOf((String)config.getString(itemId + ".material"));
        this.enchanted = config.getBoolean(itemId + ".enchanted");
        this.customModelData = config.getInt(itemId + ".customModelData");
        this.customItemType = config.getString(itemId + ".customItemType");
        this.customHeartValue = config.getInt(itemId + ".customHeartValue");
        this.minHearts = config.getInt(itemId + ".minHearts");
        this.maxHearts = config.getInt(itemId + ".maxHearts");
        this.craftable = config.getBoolean(itemId + ".craftable");
        this.requirePermission = config.getBoolean(itemId + ".requirePermission");
        this.invulnerable = config.getBoolean(itemId + ".invulnerable");
        this.despawnable = config.getBoolean(itemId + ".despawnable");
    }

    public CustomItemSoundData getSound() {
        return new CustomItemSoundData(this.itemId);
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean isEnchanted() {
        return this.enchanted;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public String getCustomItemType() {
        return this.customItemType;
    }

    public int getCustomHeartValue() {
        return this.customHeartValue;
    }

    public int getMinHearts() {
        return this.minHearts;
    }

    public int getMaxHearts() {
        return this.maxHearts;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public boolean requiresPermission() {
        return this.requirePermission;
    }

    public String getPermission() {
        return "lifestealz.item." + this.itemId;
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public boolean isDespawnable() {
        return this.despawnable;
    }

    public static class CustomItemSoundData {
        private final boolean enabled;
        private final Sound sound;
        private final double volume;
        private final double pitch;

        private CustomItemSoundData(String itemId) {
            FileConfiguration config = LifeStealZ.getInstance().getConfigManager().getCustomItemConfig();
            this.enabled = config.getBoolean(itemId + ".sound.enabled");
            this.sound = Sound.valueOf((String)config.getString(itemId + ".sound.sound"));
            this.volume = config.getDouble(itemId + ".sound.volume");
            this.pitch = config.getDouble(itemId + ".sound.pitch");
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Sound getSound() {
            return this.sound;
        }

        public double getVolume() {
            return this.volume;
        }

        public double getPitch() {
            return this.pitch;
        }
    }
}

