/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.util.commands;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.commands.EliminateCommand;
import org.strassburger.lifestealz.commands.HeartCommand;
import org.strassburger.lifestealz.commands.MainCommand.MainCommandHandler;
import org.strassburger.lifestealz.commands.MainCommand.MainTabCompleter;
import org.strassburger.lifestealz.commands.ReviveCommand;
import org.strassburger.lifestealz.commands.WithdrawCommand;
import org.strassburger.lifestealz.util.MessageUtils;

public final class CommandManager {
    private final LifeStealZ plugin;

    public CommandManager(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    public void registerCommands() {
        this.registerCommand("lifestealz", new MainCommandHandler(this.plugin), new MainTabCompleter(this.plugin));
        this.registerCommand("hearts", new HeartCommand(this.plugin), new HeartCommand(this.plugin));
        this.registerCommand("withdrawheart", new WithdrawCommand(this.plugin), new WithdrawCommand(this.plugin));
        this.registerCommand("revive", new ReviveCommand(this.plugin), new ReviveCommand(this.plugin));
        this.registerCommand("eliminate", new EliminateCommand(this.plugin), new EliminateCommand(this.plugin));
    }

    private void registerCommand(String name, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand command = this.plugin.getCommand(name);
        if (command != null) {
            command.setExecutor(executor);
            command.setTabCompleter(tabCompleter);
            command.permissionMessage(MessageUtils.getAndFormatMsg(false, "noPermsError", "<red>You do not have permission to execute this command!", new MessageUtils.Replaceable[0]));
        }
    }
}

