/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.util;

import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.listeners.EntityDamageByEntityListener;
import org.strassburger.lifestealz.listeners.EntityResurrectListener;
import org.strassburger.lifestealz.listeners.InteractionEntityEventListener;
import org.strassburger.lifestealz.listeners.InteractionListener;
import org.strassburger.lifestealz.listeners.InventoryClickListener;
import org.strassburger.lifestealz.listeners.InventoryCloseListener;
import org.strassburger.lifestealz.listeners.PlayerDeathListener;
import org.strassburger.lifestealz.listeners.PlayerDropItemListener;
import org.strassburger.lifestealz.listeners.PlayerItemPickupListener;
import org.strassburger.lifestealz.listeners.PlayerJoinListener;
import org.strassburger.lifestealz.listeners.PlayerLoginListener;
import org.strassburger.lifestealz.listeners.PrepareGrindstone;
import org.strassburger.lifestealz.listeners.PrepareItemCraft;
import org.strassburger.lifestealz.listeners.WorldSwitchListener;

public final class EventManager {
    private final LifeStealZ plugin;

    public EventManager(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    public void registerListeners() {
        this.registerListener(new PlayerJoinListener(this.plugin));
        this.registerListener(new PlayerLoginListener(this.plugin));
        this.registerListener(new EntityDamageByEntityListener(this.plugin));
        this.registerListener(new EntityResurrectListener(this.plugin));
        this.registerListener(new InteractionListener(this.plugin));
        this.registerListener(new InventoryCloseListener(this.plugin));
        this.registerListener(new InventoryClickListener(this.plugin));
        this.registerListener(new PlayerDeathListener(this.plugin));
        this.registerListener(new WorldSwitchListener(this.plugin));
        this.registerListener(new PlayerItemPickupListener(this.plugin));
        this.registerListener(new InteractionEntityEventListener(this.plugin));
        this.registerListener(new PrepareItemCraft());
        this.registerListener(new PrepareGrindstone());
        this.registerListener(new PlayerDropItemListener());
    }

    private void registerListener(Listener listener) {
        this.plugin.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
    }
}

