/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.storage;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.storage.SQLStorage;
import org.strassburger.lifestealz.storage.connectionPool.ConnectionPool;
import org.strassburger.lifestealz.storage.connectionPool.SQLiteConnectionPool;

public final class SQLiteStorage
extends SQLStorage {
    private final SQLiteConnectionPool connectionPool = new SQLiteConnectionPool(this.getPlugin().getDataFolder().getPath() + "/userData.db");

    public SQLiteStorage(LifeStealZ plugin) {
        super(plugin);
    }

    @Override
    protected void migrateDatabase() {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info(hearts)");){
            boolean hasFirstJoin = false;
            while (resultSet.next()) {
                if (!"firstJoin".equalsIgnoreCase(resultSet.getString("name"))) continue;
                hasFirstJoin = true;
                break;
            }
            if (!hasFirstJoin) {
                this.getPlugin().getLogger().info("Adding 'firstJoin' column to 'hearts' table.");
                statement.executeUpdate("ALTER TABLE hearts ADD COLUMN firstJoin INTEGER DEFAULT 0");
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to migrate database: ", e);
        }
    }

    @Override
    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    protected String getInserOrReplaceStatement() {
        return "INSERT OR REPLACE INTO hearts (uuid, name, maxhp, hasbeenRevived, craftedHearts, craftedRevives, killedOtherPlayers, firstJoin) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    }
}

