/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.storage.PlayerData;
import org.strassburger.lifestealz.storage.Storage;
import org.strassburger.lifestealz.storage.connectionPool.ConnectionPool;

public abstract class SQLStorage
extends Storage {
    private static final String CSV_SEPARATOR = ",";

    public SQLStorage(LifeStealZ plugin) {
        super(plugin);
    }

    @Override
    public void init() {
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                StringBuilder sql = new StringBuilder();
                sql.append("CREATE TABLE IF NOT EXISTS hearts (").append("uuid CHAR(36) PRIMARY KEY, ").append("name VARCHAR(64) NOT NULL, ").append("maxhp FLOAT NOT NULL DEFAULT 20.0, ").append("hasbeenRevived SMALLINT NOT NULL DEFAULT 0, ").append("craftedHearts SMALLINT UNSIGNED NOT NULL DEFAULT 0, ").append("craftedRevives SMALLINT UNSIGNED NOT NULL DEFAULT 0, ").append("killedOtherPlayers MEDIUMINT UNSIGNED NOT NULL DEFAULT 0, ").append("firstJoin BIGINT UNSIGNED NOT NULL").append(");");
                statement.executeUpdate(sql.toString());
                this.migrateDatabase();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to initialize SQL database:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to initialize SQL database:", e);
        }
    }

    public abstract ConnectionPool getConnectionPool();

    public Connection getConnection() throws SQLException {
        return this.getConnectionPool().getConnection();
    }

    /*
     * Exception decompiling
     */
    @Override
    public PlayerData load(UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PlayerData mapResultSetToPlayerData(ResultSet resultSet, UUID uuid) throws SQLException {
        PlayerData playerData = new PlayerData(resultSet.getString("name"), uuid);
        playerData.setMaxHealth(resultSet.getDouble("maxhp"));
        playerData.setHasBeenRevived(resultSet.getInt("hasbeenRevived"));
        playerData.setCraftedHearts(resultSet.getInt("craftedHearts"));
        playerData.setCraftedRevives(resultSet.getInt("craftedRevives"));
        playerData.setKilledOtherPlayers(resultSet.getInt("killedOtherPlayers"));
        playerData.setFirstJoin(resultSet.getLong("firstJoin"));
        playerData.clearModifiedFields();
        return playerData;
    }

    @Override
    public void save(PlayerData playerData) {
        if (!playerData.hasChanges()) {
            return;
        }
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            boolean exists = this.checkIfEntryExists(connection, playerData.getUuid());
            if (exists) {
                this.updatePlayerData(connection, playerData);
            } else {
                this.insertPlayerData(connection, playerData);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save player data:", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfEntryExists(Connection connection, String uuid) {
        String selectQuery = "SELECT 1 FROM hearts WHERE uuid = ?";
        try (PreparedStatement selectStmt = connection.prepareStatement("SELECT 1 FROM hearts WHERE uuid = ?");){
            boolean bl;
            block14: {
                selectStmt.setString(1, uuid);
                ResultSet resultSet = selectStmt.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to check if player entry exists:", e);
            return false;
        }
    }

    private boolean insertPlayerData(Connection connection, PlayerData playerData) {
        boolean bl;
        block8: {
            String insertQuery = "INSERT INTO hearts (uuid, name, maxhp, hasbeenRevived, craftedHearts, craftedRevives, killedOtherPlayers, firstJoin) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement insertStmt = connection.prepareStatement("INSERT INTO hearts (uuid, name, maxhp, hasbeenRevived, craftedHearts, craftedRevives, killedOtherPlayers, firstJoin) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            try {
                insertStmt.setString(1, playerData.getUuid());
                insertStmt.setString(2, playerData.getName());
                insertStmt.setDouble(3, playerData.getMaxHealth());
                insertStmt.setInt(4, playerData.getHasBeenRevived());
                insertStmt.setInt(5, playerData.getCraftedHearts());
                insertStmt.setInt(6, playerData.getCraftedRevives());
                insertStmt.setInt(7, playerData.getKilledOtherPlayers());
                insertStmt.setLong(8, playerData.getFirstJoin());
                insertStmt.executeUpdate();
                playerData.clearModifiedFields();
                bl = true;
                if (insertStmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (insertStmt != null) {
                        try {
                            insertStmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to insert player data:", e);
                    return false;
                }
            }
            insertStmt.close();
        }
        return bl;
    }

    private boolean updatePlayerData(Connection connection, PlayerData playerData) {
        boolean bl;
        block26: {
            StringBuilder updateQuery = new StringBuilder("UPDATE hearts SET ");
            ArrayList<Object> params = new ArrayList<Object>();
            for (String field : playerData.getModifiedFields()) {
                updateQuery.append(field).append(" = ?, ");
                switch (field) {
                    case "maxhp": {
                        params.add(playerData.getMaxHealth());
                        break;
                    }
                    case "hasbeenRevived": {
                        params.add(playerData.getHasBeenRevived());
                        break;
                    }
                    case "craftedHearts": {
                        params.add(playerData.getCraftedHearts());
                        break;
                    }
                    case "craftedRevives": {
                        params.add(playerData.getCraftedRevives());
                        break;
                    }
                    case "killedOtherPlayers": {
                        params.add(playerData.getKilledOtherPlayers());
                        break;
                    }
                    case "firstJoin": {
                        params.add(playerData.getFirstJoin());
                    }
                }
            }
            updateQuery.setLength(updateQuery.length() - 2);
            updateQuery.append(" WHERE uuid = ?");
            params.add(playerData.getUuid());
            PreparedStatement updateStmt = connection.prepareStatement(updateQuery.toString());
            try {
                for (int i = 0; i < params.size(); ++i) {
                    updateStmt.setObject(i + 1, params.get(i));
                }
                updateStmt.executeUpdate();
                playerData.clearModifiedFields();
                bl = true;
                if (updateStmt == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (updateStmt != null) {
                        try {
                            updateStmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to update player data:", e);
                    return false;
                }
            }
            updateStmt.close();
        }
        return bl;
    }

    @Override
    public PlayerData load(String uuid) {
        return this.load(UUID.fromString(uuid));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<UUID> getEliminatedPlayers() {
        ArrayList<UUID> eliminatedPlayers = new ArrayList<UUID>();
        int minHearts = this.getPlugin().getConfig().getInt("minHearts");
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                ArrayList<UUID> arrayList = eliminatedPlayers;
                return arrayList;
            }
            try (Statement statement = connection.createStatement();){
                statement.setQueryTimeout(30);
                ResultSet resultSet = statement.executeQuery("SELECT uuid FROM hearts WHERE maxhp <= " + minHearts * 2 + ".0");
                while (resultSet.next()) {
                    eliminatedPlayers.add(UUID.fromString(resultSet.getString("uuid")));
                }
                return eliminatedPlayers;
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to get eliminated players from SQL database:", e);
                return eliminatedPlayers;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to get eliminated players from SQL database:", e);
        }
        return eliminatedPlayers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String export(String fileName) {
        String filePath = this.getPlugin().getDataFolder().getPath() + "/" + fileName + ".csv";
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                String string = null;
                return string;
            }
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT * FROM hearts");
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                    while (resultSet.next()) {
                        String line = resultSet.getString("uuid") + CSV_SEPARATOR + resultSet.getString("name") + CSV_SEPARATOR + resultSet.getDouble("maxhp") + CSV_SEPARATOR + resultSet.getInt("hasbeenRevived") + CSV_SEPARATOR + resultSet.getInt("craftedHearts") + CSV_SEPARATOR + resultSet.getInt("craftedRevives") + CSV_SEPARATOR + resultSet.getInt("killedOtherPlayers") + CSV_SEPARATOR + resultSet.getLong("firstJoin");
                        writer.write(line);
                        writer.newLine();
                    }
                    return filePath;
                }
            }
            catch (IOException | SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to export player data to CSV file:", e);
                String string = null;
                if (connection == null) return string;
                connection.close();
                return string;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to export player data to CSV file:", e);
            return null;
        }
    }

    protected abstract String getInserOrReplaceStatement();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(String fileName) {
        String filePath = this.getPlugin().getDataFolder().getPath() + "/" + fileName;
        long startTime = System.currentTimeMillis();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));
             Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            connection.setAutoCommit(false);
            String sql = this.getInserOrReplaceStatement();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                String line;
                int batchSize = 0;
                int totalRows = 0;
                while ((line = reader.readLine()) != null) {
                    String[] data = line.split(CSV_SEPARATOR);
                    if (data.length != 8) {
                        this.getPlugin().getLogger().severe("Invalid CSV format. Expected 8 columns, but got " + data.length);
                        continue;
                    }
                    ++totalRows;
                    statement.setString(1, data[0]);
                    statement.setString(2, data[1]);
                    statement.setDouble(3, Double.parseDouble(data[2]));
                    statement.setInt(4, Integer.parseInt(data[3]));
                    statement.setInt(5, Integer.parseInt(data[4]));
                    statement.setInt(6, Integer.parseInt(data[5]));
                    statement.setInt(7, Integer.parseInt(data[6]));
                    statement.setLong(8, Long.parseLong(data[7]));
                    statement.addBatch();
                    if (++batchSize % 500 != 0) continue;
                    this.getPlugin().getLogger().info("Imported " + totalRows + " player data entries. Committing batch...");
                    statement.executeBatch();
                }
                statement.executeBatch();
                connection.commit();
                long endTime = System.currentTimeMillis();
                this.getPlugin().getLogger().info("Imported " + totalRows + " player data entries in " + (endTime - startTime) + "ms");
            }
            catch (SQLException e) {
                connection.rollback();
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to import player data:", e);
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (IOException | SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to read CSV file:", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int reviveAllPlayers(int minHearts, int reviveHearts, int maxRevives, boolean bypassReviveLimit) {
        int affectedPlayers = 0;
        String sql = "UPDATE hearts SET maxhp = ?, hasbeenRevived = hasbeenRevived + 1 WHERE maxhp <= ? AND (hasbeenRevived < ?)";
        if (bypassReviveLimit || maxRevives < 0) {
            sql = "UPDATE hearts SET maxhp = ?, hasbeenRevived = hasbeenRevived + 1 WHERE maxhp <= ?";
        }
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                int n = affectedPlayers;
                return n;
            }
            try (PreparedStatement pstmt = connection.prepareStatement(sql);){
                pstmt.setDouble(1, reviveHearts * 2);
                pstmt.setDouble(2, minHearts * 2);
                if (!bypassReviveLimit && maxRevives >= 0) {
                    pstmt.setInt(3, maxRevives);
                }
                affectedPlayers = pstmt.executeUpdate();
                return affectedPlayers;
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to revive all players in SQL database:", e);
                return affectedPlayers;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to revive all players in SQL database:", e);
        }
        return affectedPlayers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                ArrayList<String> arrayList = playerNames;
                return arrayList;
            }
            try (Statement statement = connection.createStatement();){
                statement.setQueryTimeout(30);
                ResultSet resultSet = statement.executeQuery("SELECT name FROM hearts");
                while (resultSet.next()) {
                    playerNames.add(resultSet.getString("name"));
                }
                return playerNames;
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to load player names from SQL database:", e);
                return playerNames;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to load player names from SQL database:", e);
        }
        return playerNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getEliminatedPlayerNames() {
        ArrayList<String> eliminatedPlayerNames = new ArrayList<String>();
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                ArrayList<String> arrayList = eliminatedPlayerNames;
                return arrayList;
            }
            try (Statement statement = connection.createStatement();){
                statement.setQueryTimeout(30);
                ResultSet resultSet = statement.executeQuery("SELECT name FROM hearts WHERE maxhp <= 0.0");
                while (resultSet.next()) {
                    eliminatedPlayerNames.add(resultSet.getString("name"));
                }
                return eliminatedPlayerNames;
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to get eliminated players from SQL database:", e);
                return eliminatedPlayerNames;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to get eliminated players from SQL database:", e);
        }
        return eliminatedPlayerNames;
    }

    @Override
    public void clearDatabase() {
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("DELETE FROM hearts");
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to clear SQL database:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to clear SQL database:", e);
        }
    }
}

