/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.listeners;

import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.storage.PlayerData;

public final class WorldSwitchListener
implements Listener {
    private final LifeStealZ plugin;

    public WorldSwitchListener(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onWorldSwitch(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        World fromWorld = event.getFrom();
        World toWorld = player.getLocation().getWorld();
        List worldWhitelist = this.plugin.getConfig().getStringList("worlds");
        if (worldWhitelist.contains(toWorld.getName())) {
            this.handleWhitelistedWorld(player, fromWorld, worldWhitelist);
        } else {
            LifeStealZ.setMaxHealth(player, 20.0);
        }
    }

    private void handleWhitelistedWorld(Player player, World fromWorld, List<String> worldWhitelist) {
        PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
        LifeStealZ.setMaxHealth(player, playerData.getMaxHealth());
        if (!worldWhitelist.contains(fromWorld.getName())) {
            player.setHealth(playerData.getMaxHealth());
        }
    }
}

