/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.listeners;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.storage.PlayerData;
import org.strassburger.lifestealz.storage.Storage;
import org.strassburger.lifestealz.util.MessageUtils;
import org.strassburger.lifestealz.util.WhitelistManager;
import org.strassburger.lifestealz.util.geysermc.GeyserManager;
import org.strassburger.lifestealz.util.geysermc.GeyserPlayerFile;

public final class PlayerJoinListener
implements Listener {
    private final LifeStealZ plugin;
    private final GeyserManager geyserManager;
    private final GeyserPlayerFile geyserPlayerFile;

    public PlayerJoinListener(LifeStealZ plugin) {
        this.plugin = plugin;
        this.geyserManager = plugin.getGeyserManager();
        this.geyserPlayerFile = plugin.getGeyserPlayerFile();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Storage storage = this.plugin.getStorage();
        if (this.plugin.hasGeyser() && this.geyserManager.isBedrockPlayer(player)) {
            this.geyserPlayerFile.savePlayer(player.getUniqueId(), player.getName());
        }
        if (!WhitelistManager.isWorldWhitelisted(player)) {
            this.handleUnwhitelistedWorld(player);
            return;
        }
        PlayerData playerData = this.loadOrCreatePlayerData(player, storage);
        LifeStealZ.setMaxHealth(player, playerData.getMaxHealth());
        this.notifyOpAboutUpdate(player);
    }

    private void handleUnwhitelistedWorld(Player player) {
        if ((player.hasPermission("lifestealz.admin.*") || player.isOp()) && !this.plugin.getConfig().getBoolean("suppressWhitelistMessage", false)) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "unwhitelistedWorld", "\n<red><b><grey>></grey> World Whitelist</b></red>\n\n<gray>You are currently playing on world <red><click:COPY_TO_CLIPBOARD:'&world&'><hover:show_text:'&7Copy to clipboard'>&world&</hover></click></red>.\nThis world is not whitelisted. LSZ won't activate here.\n</gray>\n<red><u><click:open_url:'https://lsz.strassburger.dev/configuration/whitelist'>Documentation</click></u></red>   <red><u><click:open_url:'https://strassburger.org/discord'>Support Discord</click></u></red>   <u><hover:show_text:'<gray>To ignore: \nSet 'supressWhitelistMessage' to <b>true</b> in the config file.</gray>'><red>Hide Message</red></hover></u>\n", new MessageUtils.Replaceable("&world&", player.getLocation().getWorld().getName())));
        }
    }

    private PlayerData loadOrCreatePlayerData(Player player, Storage storage) {
        PlayerData playerData = storage.load(player.getUniqueId());
        if (playerData == null) {
            playerData = new PlayerData(player.getName(), player.getUniqueId());
            storage.save(playerData);
            this.plugin.getOfflinePlayerCache().addItem(player.getName());
        }
        return playerData;
    }

    private void notifyOpAboutUpdate(Player player) {
        if (player.isOp() && this.plugin.getConfig().getBoolean("checkForUpdates") && this.plugin.getVersionChecker().isNewVersionAvailable()) {
            player.sendMessage(MessageUtils.getAndFormatMsg(true, "newVersionAvailable", "&7A new version of LifeStealZ is available!\\n&c<click:OPEN_URL:https://modrinth.com/plugin/lifestealz/versions>https://modrinth.com/plugin/lifestealz/versions</click>", new MessageUtils.Replaceable[0]));
        }
    }
}

