/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.listeners;

import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.strassburger.lifestealz.util.customitems.CustomItemManager;

public class PlayerDropItemListener
implements Listener {
    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Item item = event.getItemDrop();
        if (CustomItemManager.isForbiddenItem(item.getItemStack())) {
            item.remove();
            return;
        }
        ItemMeta itemMeta = item.getItemStack().getItemMeta();
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        if (container.has(CustomItemManager.DESPAWNABLE_KEY) && !Boolean.TRUE.equals(container.get(CustomItemManager.DESPAWNABLE_KEY, PersistentDataType.BOOLEAN))) {
            item.setUnlimitedLifetime(true);
        }
        if (container.has(CustomItemManager.INVULNERABLE_KEY)) {
            item.setInvulnerable(Boolean.TRUE.equals(container.get(CustomItemManager.INVULNERABLE_KEY, PersistentDataType.BOOLEAN)));
        }
    }
}

