/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.listeners;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.storage.PlayerData;
import org.strassburger.lifestealz.util.CooldownManager;
import org.strassburger.lifestealz.util.GracePeriodManager;
import org.strassburger.lifestealz.util.MessageUtils;
import org.strassburger.lifestealz.util.WebHookManager;
import org.strassburger.lifestealz.util.WhitelistManager;
import org.strassburger.lifestealz.util.customitems.CustomItemManager;
import org.strassburger.lifestealz.util.worldguard.WorldGuardManager;

public final class PlayerDeathListener
implements Listener {
    private final LifeStealZ plugin;

    public PlayerDeathListener(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        boolean looseHeartsToPlayer;
        boolean isDeathByPlayer;
        Player player = event.getEntity();
        Player killer = player.getKiller();
        if (!WhitelistManager.isWorldWhitelisted(player)) {
            return;
        }
        if (this.plugin.hasWorldGuard() && !WorldGuardManager.checkHeartLossFlag(player)) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        if (player.hasMetadata("combat_log_npc")) {
            playerUUID = (UUID)((MetadataValue)player.getMetadata("combat_log_npc").get(0)).value();
        }
        PlayerData playerData = this.plugin.getStorage().load(playerUUID);
        boolean bl = isDeathByPlayer = killer != null && !killer.getUniqueId().equals(playerUUID);
        if (this.handleAntiAltLogic(player, killer)) {
            return;
        }
        boolean looseHeartsToNature = this.plugin.getConfig().getBoolean("looseHeartsToNature") || this.plugin.getConfig().getInt("heartsPerKill") <= 0;
        boolean bl2 = looseHeartsToPlayer = this.plugin.getConfig().getBoolean("looseHeartsToPlayer") || this.plugin.getConfig().getInt("heartsPerNaturalDeath") <= 0;
        if (!isDeathByPlayer && looseHeartsToNature || isDeathByPlayer && looseHeartsToPlayer) {
            this.handleHeartLoss(event, player, killer, playerData, isDeathByPlayer);
        }
    }

    private void handleHeartLoss(PlayerDeathEvent event, Player player, Player killer, PlayerData playerData, boolean isDeathByPlayer) {
        double healthToLoose;
        double minHearts = this.plugin.getConfig().getInt("minHearts") * 2;
        double healthPerKill = this.plugin.getConfig().getInt("heartsPerKill") * 2;
        double healthPerNaturalDeath = this.plugin.getConfig().getInt("heartsPerNaturalDeath") * 2;
        double d = healthToLoose = isDeathByPlayer ? healthPerKill : healthPerNaturalDeath;
        if (this.restrictedHeartLossByGracePeriod(player) && isDeathByPlayer) {
            killer.sendMessage(MessageUtils.getAndFormatMsg(false, "noHeartGainFromPlayersInGracePeriod", "&cYou can't gain hearts from players during their grace period!", new MessageUtils.Replaceable[0]));
        } else if (isDeathByPlayer && this.restrictedHeartGainByGracePeriod(killer)) {
            killer.sendMessage(MessageUtils.getAndFormatMsg(false, "noHeartGainInGracePeriod", "&cYou can't gain hearts during the grace period!", new MessageUtils.Replaceable[0]));
        } else if (isDeathByPlayer && this.plugin.getConfig().getBoolean("dropHeartsPlayer")) {
            this.dropHeartsNaturally(player.getLocation(), (int)(healthToLoose / 2.0), CustomItemManager.createKillHeart());
        } else if (isDeathByPlayer) {
            this.handleKillerHeartGain(playerData, killer, healthToLoose);
        } else if (this.plugin.getConfig().getBoolean("dropHeartsNatural")) {
            this.dropHeartsNaturally(player.getLocation(), (int)(healthToLoose / 2.0), CustomItemManager.createNaturalDeathHeart());
        }
        if (this.restrictedHeartLossByGracePeriod(player)) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "noHeartLossInGracePeriod", "&cYou can't lose hearts during the grace period!", new MessageUtils.Replaceable[0]));
            return;
        }
        if (isDeathByPlayer && this.restrictedHeartGainByGracePeriod(killer)) {
            return;
        }
        if (playerData.getMaxHealth() - healthToLoose <= minHearts) {
            this.handleElimination(event, player, playerData, killer, isDeathByPlayer);
            return;
        }
        playerData.setMaxHealth(playerData.getMaxHealth() - healthToLoose);
        this.plugin.getStorage().save(playerData);
        LifeStealZ.setMaxHealth(player, playerData.getMaxHealth());
    }

    private void handleElimination(PlayerDeathEvent event, Player player, PlayerData playerData, Player killer, boolean isDeathByPlayer) {
        List elimCommands = this.plugin.getConfig().getStringList("eliminationCommands");
        boolean disableBanOnElimination = this.plugin.getConfig().getBoolean("disablePlayerBanOnElimination");
        boolean announceElimination = this.plugin.getConfig().getBoolean("announceElimination");
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            for (String command : elimCommands) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command.replace("&player&", player.getName()));
            }
        }, 1L);
        if (disableBanOnElimination) {
            double respawnHP = this.plugin.getConfig().getInt("reviveHearts") * 2;
            playerData.setMaxHealth(respawnHP);
            this.plugin.getStorage().save(playerData);
            LifeStealZ.setMaxHealth(player, respawnHP);
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            Component kickMessage = MessageUtils.getAndFormatMsg(false, "eliminatedJoin", "&cYou don't have any hearts left!", new MessageUtils.Replaceable[0]);
            if (player.isOnline()) {
                player.kick(kickMessage);
            }
        }, 1L);
        if (announceElimination) {
            String messageKey = isDeathByPlayer ? "eliminationAnnouncement" : "eliminateionAnnouncementNature";
            Bukkit.broadcast((Component)MessageUtils.getAndFormatMsg(false, messageKey, isDeathByPlayer ? "&c%player% &7has been eliminated by &c%killer%&7!" : "&c%player% &7has been eliminated!", new MessageUtils.Replaceable("%player%", player.getName()), new MessageUtils.Replaceable("%killer%", killer != null ? killer.getName() : "")));
            event.setDeathMessage(null);
        }
        this.plugin.getWebHookManager().sendWebhookMessage(WebHookManager.WebHookType.ELIMINATION, player.getName(), killer != null ? killer.getName() : "");
        playerData.setMaxHealth(0.0);
        this.plugin.getStorage().save(playerData);
        this.plugin.getEliminatedPlayersCache().addEliminatedPlayer(player.getName());
    }

    private void handleKillerHeartGain(PlayerData playerData, Player killer, double healthGain) {
        boolean heartGainCooldownEnabled = this.plugin.getConfig().getBoolean("heartGainCooldown.enabled");
        long heartGainCooldown = this.plugin.getConfig().getLong("heartGainCooldown.cooldown");
        boolean heartGainCooldownDropOnCooldown = this.plugin.getConfig().getBoolean("heartGainCooldown.dropOnCooldown");
        double maxHearts = this.plugin.getConfig().getInt("maxHearts") * 2;
        double minHearts = this.plugin.getConfig().getInt("minHearts") * 2;
        boolean heartRewardOnElimination = this.plugin.getConfig().getBoolean("heartRewardOnElimination");
        boolean dropHeartsIfMax = this.plugin.getConfig().getBoolean("dropHeartsIfMax");
        PlayerData killerPlayerData = this.plugin.getStorage().load(killer.getUniqueId());
        if (heartGainCooldownEnabled && CooldownManager.lastHeartGain.get(killer.getUniqueId()) != null && CooldownManager.lastHeartGain.get(killer.getUniqueId()) + heartGainCooldown > System.currentTimeMillis()) {
            long timeLeft = (CooldownManager.lastHeartGain.get(killer.getUniqueId()) + heartGainCooldown - System.currentTimeMillis()) / 1000L;
            killer.sendMessage(MessageUtils.getAndFormatMsg(false, "heartGainCooldown", "&cYou have to wait before gaining another heart!", new MessageUtils.Replaceable("%time%", MessageUtils.formatTime(timeLeft))));
            if (heartGainCooldownDropOnCooldown) {
                this.dropHeartsNaturally(killer.getLocation(), (int)(healthGain / 2.0), CustomItemManager.createHeartGainCooldownHeart());
            }
        } else if (playerData.getMaxHealth() - healthGain > minHearts || playerData.getMaxHealth() - healthGain <= minHearts && heartRewardOnElimination) {
            if (killerPlayerData.getMaxHealth() + healthGain > maxHearts) {
                if (dropHeartsIfMax) {
                    this.dropHeartsNaturally(killer.getLocation(), (int)(healthGain / 2.0), CustomItemManager.createMaxHealthHeart());
                } else {
                    killer.sendMessage(MessageUtils.getAndFormatMsg(false, "maxHeartLimitReached", "&cYou already reached the limit of %limit% hearts!", new MessageUtils.Replaceable("%limit%", "" + (int)maxHearts / 2)));
                }
            } else {
                killerPlayerData.setMaxHealth(killerPlayerData.getMaxHealth() + healthGain);
                this.plugin.getStorage().save(killerPlayerData);
                LifeStealZ.setMaxHealth(killer, killerPlayerData.getMaxHealth());
                killer.setHealth(Math.min(killer.getHealth() + healthGain, killerPlayerData.getMaxHealth()));
                CooldownManager.lastHeartGain.put(killer.getUniqueId(), System.currentTimeMillis());
            }
        }
    }

    private boolean handleAntiAltLogic(Player player, @Nullable Player killer) {
        if (killer == null || player.getUniqueId().equals(killer.getUniqueId())) {
            return false;
        }
        String victimIP = this.getPlayerIP(player);
        String killerIP = this.getPlayerIP(killer);
        if (victimIP != null && victimIP.equals(killerIP) && this.plugin.getConfig().getBoolean("antiAlt.enabled")) {
            if (this.plugin.getConfig().getBoolean("antiAlt.logAttempt")) {
                this.plugin.getLogger().info("[ALT WARNING] Player " + killer.getName() + " tried to kill " + player.getName() + " with the same IP address! (Probably an alt account)");
            }
            if (this.plugin.getConfig().getBoolean("antiAlt.sendMessage")) {
                killer.sendMessage(MessageUtils.getAndFormatMsg(false, "altKill", "&cPlease don't kill alts! This attempt has been logged!", new MessageUtils.Replaceable[0]));
            }
            for (String command : this.plugin.getConfig().getStringList("antiAlt.commands")) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command.replace("&player&", killer.getName()));
            }
            return this.plugin.getConfig().getBoolean("antiAlt.preventKill");
        }
        return false;
    }

    private String getPlayerIP(Player player) {
        InetSocketAddress inetSocketAddress = player.getAddress();
        if (inetSocketAddress == null) {
            return null;
        }
        InetAddress address = inetSocketAddress.getAddress();
        return address.getHostAddress();
    }

    private void dropHeartsNaturally(Location location, int amount, ItemStack itemStack) {
        World world = location.getWorld();
        for (int i = 0; i < amount; ++i) {
            world.dropItemNaturally(location, itemStack);
        }
    }

    private boolean restrictedHeartLossByGracePeriod(Player player) {
        GracePeriodManager gracePeriodManager = this.plugin.getGracePeriodManager();
        return gracePeriodManager.isInGracePeriod((OfflinePlayer)player) && !gracePeriodManager.getConfig().looseHearts();
    }

    private boolean restrictedHeartGainByGracePeriod(Player player) {
        GracePeriodManager gracePeriodManager = this.plugin.getGracePeriodManager();
        return gracePeriodManager.isInGracePeriod((OfflinePlayer)player) && !gracePeriodManager.getConfig().gainHearts();
    }
}

