/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.listeners;

import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.storage.PlayerData;
import org.strassburger.lifestealz.util.GuiManager;
import org.strassburger.lifestealz.util.MessageUtils;
import org.strassburger.lifestealz.util.WebHookManager;
import org.strassburger.lifestealz.util.commands.CommandUtils;
import org.strassburger.lifestealz.util.customitems.CustomItemManager;

public final class InventoryClickListener
implements Listener {
    private final LifeStealZ plugin;

    public InventoryClickListener(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory openInventory = player.getOpenInventory().getTopInventory();
        if (openInventory.equals((Object)GuiManager.RECIPE_GUI_MAP.get(event.getWhoClicked().getUniqueId()))) {
            event.setCancelled(true);
            if (event.getCurrentItem() != null && event.getCurrentItem().getType() == Material.BARRIER) {
                event.getWhoClicked().closeInventory();
            }
            return;
        }
        if (openInventory.equals((Object)GuiManager.REVIVE_GUI_MAP.get(event.getWhoClicked().getUniqueId()))) {
            int reviveMaximum = this.plugin.getConfig().getInt("maxRevives");
            int minHearts = this.plugin.getConfig().getInt("minHearts");
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem();
            if (item == null || item.getType() == Material.AIR || !(event.getWhoClicked() instanceof Player)) {
                return;
            }
            switch (item.getType()) {
                case BARRIER: {
                    player.closeInventory();
                    break;
                }
                case ARROW: {
                    event.setCancelled(true);
                    Integer pageInt = (Integer)item.getItemMeta().getPersistentDataContainer().get(CustomItemManager.REVIVE_PAGE_KEY, PersistentDataType.INTEGER);
                    int page = pageInt != null ? pageInt : 1;
                    GuiManager.openReviveGui(player, page);
                }
                case PLAYER_HEAD: {
                    if (!player.hasPermission("lifestealz.revive")) {
                        this.throwPermissionError((HumanEntity)player);
                        return;
                    }
                    if (item.lore() == null) {
                        return;
                    }
                    String uuidString = this.getLastLineOfLore(item, false);
                    if (uuidString == null) {
                        return;
                    }
                    UUID playerUUID = UUID.fromString(uuidString);
                    OfflinePlayer targetPlayer = Bukkit.getServer().getOfflinePlayer(playerUUID);
                    if (targetPlayer.getName() == null) {
                        player.sendMessage((Component)Component.text((String)"\u00a7cAn error occurred while fetching playerdata! Are you sure this is a real player?"));
                        return;
                    }
                    if (!this.hasReviveCrystal(player)) {
                        this.plugin.getLogger().warning("Player " + player.getName() + " tried to revive " + targetPlayer.getName() + " without a revive crystal!");
                        return;
                    }
                    PlayerData targetPlayerData = this.plugin.getStorage().load(playerUUID);
                    if (reviveMaximum != -1 && targetPlayerData.getHasBeenRevived() >= reviveMaximum) {
                        player.sendMessage(MessageUtils.getAndFormatMsg(false, "reviveMaxReached", "&cThis player has already been revived %amount% times!", new MessageUtils.Replaceable("%amount%", "" + targetPlayerData.getHasBeenRevived())));
                        return;
                    }
                    if (targetPlayerData.getMaxHealth() > (double)(minHearts * 2)) {
                        player.sendMessage(MessageUtils.getAndFormatMsg(false, "onlyReviveElimPlayers", "&cYou can only revive eliminated players!", new MessageUtils.Replaceable[0]));
                        return;
                    }
                    targetPlayerData.setMaxHealth(this.plugin.getConfig().getInt("reviveHearts") * 2);
                    targetPlayerData.setHasBeenRevived(targetPlayerData.getHasBeenRevived() + 1);
                    this.plugin.getStorage().save(targetPlayerData);
                    this.plugin.getEliminatedPlayersCache().removeEliminatedPlayer(targetPlayer.getName());
                    player.sendMessage(MessageUtils.getAndFormatMsg(true, "reviveSuccess", "&7You successfully revived &c%player%&7!", new MessageUtils.Replaceable("%player%", targetPlayer.getName())));
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 500.0f, 1.0f);
                    event.getInventory().close();
                    List reviveCommands = this.plugin.getConfig().getStringList("reviveuseCommands");
                    for (String command : reviveCommands) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("&player&", player.getName()).replace("&target&", targetPlayer.getName()));
                    }
                    this.removeReviveCrystal(player);
                    this.plugin.getWebHookManager().sendWebhookMessage(WebHookManager.WebHookType.REVIVE, targetPlayer.getName(), player.getName());
                    break;
                }
                case SKELETON_SKULL: {
                    if (!player.hasPermission("lifestealz.revive")) {
                        this.throwPermissionError((HumanEntity)player);
                        return;
                    }
                    if (item.lore() == null) {
                        return;
                    }
                    String bedrockUuidString = this.getLastLineOfLore(item, true);
                    if (bedrockUuidString == null) {
                        return;
                    }
                    UUID bedrockPlayerUUID = UUID.fromString(bedrockUuidString);
                    OfflinePlayer targetBedrockPlayer = Bukkit.getServer().getOfflinePlayer(bedrockPlayerUUID);
                    if (targetBedrockPlayer.getName() == null) {
                        player.sendMessage((Component)Component.text((String)"\u00a7cAn error occurred while fetching playerdata! Are you sure this is a real player?"));
                        return;
                    }
                    if (!this.hasReviveCrystal(player)) {
                        this.plugin.getLogger().warning("Player " + player.getName() + " tried to revive " + targetBedrockPlayer.getName() + " without a revive crystal!");
                        return;
                    }
                    PlayerData targetBedrockPlayerData = this.plugin.getStorage().load(bedrockPlayerUUID);
                    if (reviveMaximum != -1 && targetBedrockPlayerData.getHasBeenRevived() >= reviveMaximum) {
                        player.sendMessage(MessageUtils.getAndFormatMsg(false, "reviveMaxReached", "&cThis player has already been revived %amount% times!", new MessageUtils.Replaceable("%amount%", "" + targetBedrockPlayerData.getHasBeenRevived())));
                        return;
                    }
                    if (targetBedrockPlayerData.getMaxHealth() > (double)(minHearts * 2)) {
                        player.sendMessage(MessageUtils.getAndFormatMsg(false, "onlyReviveElimPlayers", "&cYou can only revive eliminated players!", new MessageUtils.Replaceable[0]));
                        return;
                    }
                    targetBedrockPlayerData.setMaxHealth(this.plugin.getConfig().getInt("reviveHearts") * 2);
                    targetBedrockPlayerData.setHasBeenRevived(targetBedrockPlayerData.getHasBeenRevived() + 1);
                    this.plugin.getStorage().save(targetBedrockPlayerData);
                    this.plugin.getEliminatedPlayersCache().removeEliminatedPlayer(targetBedrockPlayer.getName());
                    player.sendMessage(MessageUtils.getAndFormatMsg(true, "reviveSuccess", "&7You successfully revived &c%player%&7!", new MessageUtils.Replaceable("%player%", targetBedrockPlayer.getName())));
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 500.0f, 1.0f);
                    event.getInventory().close();
                    List bedrockReviveCommands = this.plugin.getConfig().getStringList("reviveuseCommands");
                    for (String command : bedrockReviveCommands) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("&player&", player.getName()).replace("&target&", targetBedrockPlayer.getName()));
                    }
                    this.removeReviveCrystal(player);
                }
            }
            return;
        }
        if (event.getCurrentItem() != null && CustomItemManager.isForbiddenItem(event.getCurrentItem())) {
            event.setCancelled(true);
            event.setCurrentItem(new ItemStack(Material.AIR));
        }
    }

    private void throwPermissionError(HumanEntity player) {
        CommandUtils.throwPermissionError((CommandSender)player);
    }

    private String getLastLineOfLore(ItemStack item, boolean bedrock) {
        PlainTextComponentSerializer plainSerializer = PlainTextComponentSerializer.plainText();
        List lore = item.lore();
        if (lore == null) {
            return null;
        }
        int line = bedrock ? 2 : 1;
        Component lastLore = (Component)lore.get(lore.size() - line);
        return plainSerializer.serialize(lastLore);
    }

    private boolean hasReviveCrystal(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !CustomItemManager.isReviveItem(item)) continue;
            return true;
        }
        return false;
    }

    private void removeReviveCrystal(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !CustomItemManager.isReviveItem(item)) continue;
            item.setAmount(item.getAmount() - 1);
            return;
        }
    }
}

