/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.listeners;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.storage.PlayerData;
import org.strassburger.lifestealz.util.CooldownManager;
import org.strassburger.lifestealz.util.GracePeriodManager;
import org.strassburger.lifestealz.util.GuiManager;
import org.strassburger.lifestealz.util.MessageUtils;
import org.strassburger.lifestealz.util.WhitelistManager;
import org.strassburger.lifestealz.util.customitems.CustomItemData;
import org.strassburger.lifestealz.util.customitems.CustomItemManager;

public final class InteractionListener
implements Listener {
    private final LifeStealZ plugin;

    public InteractionListener(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteraction(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        if (this.shouldCancelRespawnAnchorUsage(event) || this.shouldCancelBedInteraction(event)) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "interactionNotAllowed", "&cYou are not allowed to interact with this!", new MessageUtils.Replaceable[0]));
            event.setCancelled(true);
            return;
        }
        if (event.getAction().isRightClick() && item != null) {
            if (CustomItemManager.isForbiddenItem(item)) {
                event.setCancelled(true);
                if (hand == null) {
                    return;
                }
                switch (hand) {
                    case HAND: {
                        player.getInventory().setItem(player.getInventory().getHeldItemSlot(), new ItemStack(Material.AIR));
                        break;
                    }
                    case OFF_HAND: {
                        player.getInventory().setItem(40, new ItemStack(Material.AIR));
                    }
                }
            }
            if (!WhitelistManager.isWorldWhitelisted(player) && (CustomItemManager.isHeartItem(item) || CustomItemManager.isReviveItem(item))) {
                player.sendMessage(MessageUtils.getAndFormatMsg(false, "worldNotWhitelisted", "&cThis world is not whitelisted for LifeStealZ!", new MessageUtils.Replaceable[0]));
                return;
            }
            if (CustomItemManager.isNonUsableItem(item)) {
                event.setCancelled(true);
                return;
            }
            if (CustomItemManager.isHeartItem(item)) {
                this.handleHeartItem(item, player, hand, event);
            }
            if (CustomItemManager.isReviveItem(item)) {
                this.handleReviveItem(item, player, hand, event);
            }
        }
    }

    private boolean shouldCancelRespawnAnchorUsage(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || !this.plugin.getConfig().getBoolean("preventRespawnAnchors")) {
            return false;
        }
        Block block = event.getClickedBlock();
        List<World.Environment> disabledEnvironments = List.of(World.Environment.NORMAL, World.Environment.THE_END);
        return block != null && block.getType() == Material.RESPAWN_ANCHOR && disabledEnvironments.contains(event.getPlayer().getWorld().getEnvironment());
    }

    private boolean shouldCancelBedInteraction(PlayerInteractEvent event) {
        List<World.Environment> disabledEnvironments = List.of(World.Environment.NETHER, World.Environment.THE_END);
        List<Material> disabledMaterials = List.of(Material.BLACK_BED, Material.BLUE_BED, Material.BROWN_BED, Material.CYAN_BED, Material.GRAY_BED, Material.GREEN_BED, Material.LIGHT_BLUE_BED, Material.LIGHT_GRAY_BED, Material.LIME_BED, Material.MAGENTA_BED, Material.ORANGE_BED, Material.PINK_BED, Material.PURPLE_BED, Material.RED_BED, Material.WHITE_BED, Material.YELLOW_BED);
        Block block = event.getClickedBlock();
        if (block == null || !this.plugin.getConfig().getBoolean("preventBeds")) {
            return false;
        }
        return event.getAction() == Action.RIGHT_CLICK_BLOCK && disabledEnvironments.contains(event.getPlayer().getWorld().getEnvironment()) && disabledMaterials.contains(block.getType());
    }

    private void handleHeartItem(ItemStack item, Player player, EquipmentSlot hand, PlayerInteractEvent event) {
        CustomItemData.CustomItemSoundData sound;
        String customItemID;
        double maxHearts;
        CustomItemData customItemData = CustomItemManager.getCustomItemData(CustomItemManager.getCustomItemId(item));
        if (customItemData == null) {
            return;
        }
        event.setCancelled(true);
        if (customItemData.requiresPermission() && !player.hasPermission(customItemData.getPermission()) && !player.isOp() && !player.hasPermission("lifestealz.item.*")) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "noPermissionError", "&cYou don't have permission to use this!", new MessageUtils.Replaceable[0]));
            return;
        }
        if (this.restrictedHeartByGracePeriod(player)) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "noHeartUseInGracePeriod", "&cYou can't use hearts during the grace period!", new MessageUtils.Replaceable[0]));
            return;
        }
        long heartCooldown = this.plugin.getConfig().getLong("heartCooldown");
        if (CooldownManager.lastHeartUse.get(player.getUniqueId()) != null && CooldownManager.lastHeartUse.get(player.getUniqueId()) + heartCooldown > System.currentTimeMillis()) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "heartconsumeCooldown", "&cYou have to wait before using another heart!", new MessageUtils.Replaceable[0]));
            return;
        }
        PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
        Integer savedHeartAmountInteger = item.getItemMeta().getPersistentDataContainer().has(CustomItemManager.CUSTOM_HEART_VALUE_KEY, PersistentDataType.INTEGER) ? (Integer)item.getItemMeta().getPersistentDataContainer().get(CustomItemManager.CUSTOM_HEART_VALUE_KEY, PersistentDataType.INTEGER) : Integer.valueOf(1);
        int savedHeartAmount = savedHeartAmountInteger != null ? savedHeartAmountInteger : 1;
        double heartsToAdd = savedHeartAmount * 2;
        double newHearts = playerData.getMaxHealth() + heartsToAdd;
        if (newHearts > (maxHearts = (double)(this.plugin.getConfig().getInt("maxHearts") * 2))) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "maxHeartLimitReached", "&cYou already reached the limit of %limit% hearts!", new MessageUtils.Replaceable("%limit%", Integer.toString((int)maxHearts / 2))));
            return;
        }
        if (playerData.getMaxHealth() < (double)(customItemData.getMinHearts() * 2) && customItemData.getMinHearts() != -1) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "itemMinHearts", "&cYou need at least %amount% hearts to use this item!", new MessageUtils.Replaceable("%amount%", Integer.toString(customItemData.getMinHearts()))));
            return;
        }
        if (playerData.getMaxHealth() >= (double)(customItemData.getMaxHearts() * 2) && customItemData.getMaxHearts() != -1) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "itemMaxHearts", "&cYou can't use this item with more than %amount% hearts!", new MessageUtils.Replaceable("%amount%", Integer.toString(customItemData.getMaxHearts()))));
            return;
        }
        if (hand == EquipmentSlot.HAND) {
            this.updateItemInHand(player, item, player.getInventory().getHeldItemSlot());
        } else if (hand == EquipmentSlot.OFF_HAND) {
            this.updateItemInHand(player, item, 40);
        }
        playerData.setMaxHealth(newHearts);
        this.plugin.getStorage().save(playerData);
        LifeStealZ.setMaxHealth(player, newHearts);
        if (this.plugin.getConfig().getBoolean("healOnHeartUse")) {
            player.setHealth(Math.min(player.getHealth() + heartsToAdd, newHearts));
        }
        if ((customItemID = CustomItemManager.getCustomItemId(item)) != null && (sound = CustomItemManager.getCustomItemData(customItemID).getSound()).isEnabled()) {
            player.playSound(player.getLocation(), sound.getSound(), (float)sound.getVolume(), (float)sound.getPitch());
        }
        List heartuseCommands = this.plugin.getConfig().getStringList("heartuseCommands");
        for (String command : heartuseCommands) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("&player&", player.getName()));
        }
        if (this.plugin.getConfig().getBoolean("playTotemEffect")) {
            this.playHeartAnimation(player);
        }
        player.sendMessage(MessageUtils.getAndFormatMsg(true, "heartconsume", "&7Consumed a heart and got &c%amount% &7hearts!", new MessageUtils.Replaceable("%amount%", "" + savedHeartAmount)));
        CooldownManager.lastHeartUse.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private void handleReviveItem(ItemStack item, Player player, EquipmentSlot hand, PlayerInteractEvent event) {
        event.setCancelled(true);
        GuiManager.openReviveGui(player, 1);
    }

    private void playHeartAnimation(final Player player) {
        final ItemStack originalOffHandItem = player.getInventory().getItemInOffHand();
        ItemStack fakeTotem = CustomItemManager.createHeartAnimationTotem();
        player.getInventory().setItemInOffHand(fakeTotem);
        new BukkitRunnable(){

            public void run() {
                player.playEffect(EntityEffect.PROTECTED_FROM_DEATH);
                player.getInventory().setItemInOffHand(originalOffHandItem);
            }
        }.runTaskLater((Plugin)this.plugin, 3L);
    }

    private void updateItemInHand(Player player, ItemStack item, int slot) {
        ItemStack updatedItem = item.clone();
        updatedItem.setAmount(item.getAmount() - 1);
        if (updatedItem.getAmount() > 0) {
            updatedItem.setItemMeta(item.getItemMeta());
        }
        player.getInventory().setItem(slot, updatedItem);
    }

    private boolean restrictedHeartByGracePeriod(Player player) {
        GracePeriodManager gracePeriodManager = this.plugin.getGracePeriodManager();
        return gracePeriodManager.isInGracePeriod((OfflinePlayer)player) && !gracePeriodManager.getConfig().useHearts();
    }
}

