/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.commands.MainCommand.subcommands;

import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.commands.SubCommand;
import org.strassburger.lifestealz.storage.PlayerData;
import org.strassburger.lifestealz.util.GracePeriodManager;
import org.strassburger.lifestealz.util.MessageUtils;
import org.strassburger.lifestealz.util.commands.CommandUtils;
import org.strassburger.lifestealz.util.customitems.CustomItem;
import org.strassburger.lifestealz.util.customitems.CustomItemManager;

public final class DevSubCommand
implements SubCommand {
    private final LifeStealZ plugin;

    public DevSubCommand(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Player player;
        if (!this.hasPermission(sender)) {
            CommandUtils.throwPermissionError(sender);
            return false;
        }
        if (args.length < 2) {
            CommandUtils.throwUsageError(sender, this.getUsage());
            return false;
        }
        String optionTwo = args[1];
        if (optionTwo.equals("giveForbiddenitem")) {
            if (!(sender instanceof Player)) {
                return false;
            }
            Player player2 = (Player)sender;
            player2.getInventory().addItem(new ItemStack[]{new CustomItem(Material.BARRIER).makeForbidden().getItemStack()});
            return true;
        }
        if (optionTwo.equals("isInGracePeriod")) {
            if (args.length < 3 && !(sender instanceof Player)) {
                CommandUtils.throwUsageError(sender, "/lifestealz dev isInGracePeriod [player]");
                return false;
            }
            Player player3 = player = args.length > 2 ? this.plugin.getServer().getPlayer(args[2]) : (Player)sender;
            if (player == null) {
                CommandUtils.throwUsageError(sender, "/lifestealz dev isInGracePeriod [player]");
                return false;
            }
            GracePeriodManager gracePeriodManager = this.plugin.getGracePeriodManager();
            String gracePeriodColor = gracePeriodManager.isInGracePeriod((OfflinePlayer)player) ? "&a" : "&c";
            String gracePeriodEnabledColor = gracePeriodManager.isEnabled() ? "&a" : "&c";
            sender.sendMessage(MessageUtils.formatMsg("&7Is &c" + player.getName() + " &7in grace period? " + gracePeriodColor + gracePeriodManager.isInGracePeriod((OfflinePlayer)player) + (String)(gracePeriodManager.isInGracePeriod((OfflinePlayer)player) ? " &7(" + String.valueOf(gracePeriodManager.getGracePeriodRemaining(player).orElse(-1)) + "remaining)" : "") + "\n&7Grace period enabled: " + gracePeriodEnabledColor + gracePeriodManager.isEnabled() + "&7", new MessageUtils.Replaceable[0]));
        }
        if (optionTwo.equals("setFirstJoinDate")) {
            if (args.length < 3 && !(sender instanceof Player)) {
                CommandUtils.throwUsageError(sender, "/lifestealz dev setFirstJoinDate [player]");
                return false;
            }
            Player player4 = player = args.length > 2 ? this.plugin.getServer().getPlayer(args[2]) : (Player)sender;
            if (player == null) {
                CommandUtils.throwUsageError(sender, "/lifestealz dev setFirstJoinDate [player]");
                return false;
            }
            long newFirstJoin = System.currentTimeMillis();
            PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
            playerData.setFirstJoin(newFirstJoin);
            this.plugin.getStorage().save(playerData);
            this.plugin.getGracePeriodManager().startGracePeriod(player);
        }
        if (optionTwo.equals("refreshCaches")) {
            this.plugin.getEliminatedPlayersCache().reloadCache();
            sender.sendMessage(MessageUtils.formatMsg("&7Caches reloaded!", new MessageUtils.Replaceable[0]));
        }
        if (optionTwo.equals("crash")) {
            throw new RuntimeException("Crash test");
        }
        if (optionTwo.equals("cleardatabase")) {
            this.plugin.getStorage().clearDatabase();
            sender.sendMessage(MessageUtils.formatMsg("&7Database cleared!", new MessageUtils.Replaceable[0]));
        }
        if (optionTwo.equals("giveAnimationTotem")) {
            if (!(sender instanceof Player)) {
                return false;
            }
            player = (Player)sender;
            player.getInventory().addItem(new ItemStack[]{CustomItemManager.createHeartAnimationTotem()});
            return true;
        }
        return false;
    }

    @Override
    public String getUsage() {
        return "/lifestealz dev <giveForbiddenitem | isInGracePeriod | setFirstJoinDate | refreshCaches | crash | cleardatabase | giveAnimationTotem>";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp();
    }
}

