/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.commands.MainCommand.subcommands;

import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.strassburger.lifestealz.LifeStealZ;
import org.strassburger.lifestealz.commands.SubCommand;
import org.strassburger.lifestealz.storage.Storage;
import org.strassburger.lifestealz.util.MessageUtils;
import org.strassburger.lifestealz.util.commands.CommandUtils;

public final class DataSubCommand
implements SubCommand {
    private final Storage storage;
    private final LifeStealZ plugin;

    public DataSubCommand(LifeStealZ plugin) {
        this.storage = plugin.getStorage();
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender)) {
            CommandUtils.throwPermissionError(sender);
            return false;
        }
        if (args.length < 3) {
            CommandUtils.throwUsageError(sender, "/lifestealz data <import | export> <file>");
            return false;
        }
        String optionTwo = args[1];
        String fileName = args[2];
        if (optionTwo.equals("export")) {
            return this.handleExport(sender, fileName);
        }
        if (optionTwo.equals("import")) {
            return this.handleImport(sender, fileName);
        }
        CommandUtils.throwUsageError(sender, this.getUsage());
        return true;
    }

    private boolean handleExport(CommandSender sender, String fileName) {
        sender.sendMessage(MessageUtils.getAndFormatMsg(true, "exportingData", "&7Exporting player data...", new MessageUtils.Replaceable[0]));
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String filePath = this.storage.export(fileName);
            if (filePath != null) {
                sender.sendMessage(MessageUtils.getAndFormatMsg(true, "exportData", "&7Successfully exported player data to &c%file%", new MessageUtils.Replaceable("%file%", filePath)));
            } else {
                sender.sendMessage(MessageUtils.getAndFormatMsg(false, "exportDataError", "&cFailed to export data! Check console for details.", new MessageUtils.Replaceable[0]));
            }
        });
        this.plugin.getAsyncTaskManager().addTask(task);
        return true;
    }

    private boolean handleImport(CommandSender sender, String fileName) {
        sender.sendMessage(MessageUtils.getAndFormatMsg(true, "importingData", "&7Importing player data...", new MessageUtils.Replaceable[0]));
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            this.storage.importData(fileName);
            sender.sendMessage(MessageUtils.getAndFormatMsg(true, "importData", "&7Successfully imported &c%file%.csv&7!\n&cPlease restart the server, to ensure flawless migration!", new MessageUtils.Replaceable("%file%", fileName)));
        });
        this.plugin.getAsyncTaskManager().addTask(task);
        return true;
    }

    @Override
    public String getUsage() {
        return "/lifestealz data <import | export> <file>";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("lifestealz.managedata");
    }
}

