/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.lifestealz.caches;

import java.util.HashSet;
import java.util.Set;
import org.strassburger.lifestealz.LifeStealZ;

public abstract class Cache<T> {
    private final Set<T> cachedData;
    private final LifeStealZ plugin;

    public Cache(LifeStealZ plugin) {
        this.plugin = plugin;
        this.cachedData = new HashSet<T>();
        this.reloadCache();
    }

    public abstract void reloadCache();

    public Set<T> getCachedData() {
        return new HashSet<T>(this.cachedData);
    }

    public void addItem(T item) {
        this.cachedData.add(item);
    }

    public void removeItem(T item) {
        this.cachedData.remove(item);
    }

    public void addAllItems(Set<T> items) {
        this.cachedData.addAll(items);
    }

    public void clearCache() {
        this.cachedData.clear();
    }

    protected LifeStealZ getPlugin() {
        return this.plugin;
    }
}

