/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.updatechecker;

import com.zetaplugins.zetacore.annotations.Manager;
import com.zetaplugins.zetacore.services.updatechecker.SemanticVersion;
import com.zetaplugins.zetacore.services.updatechecker.UpdateChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Manager
public class GitHubUpdateChecker
extends UpdateChecker {
    private final String repoOwner;
    private final String repoName;

    public GitHubUpdateChecker(JavaPlugin plugin, String repoOwner, String repoName) {
        super(plugin);
        this.repoOwner = repoOwner;
        this.repoName = repoName;
    }

    @Override
    public void checkForUpdates(boolean logMessage) {
        String latestTag = this.fetchLatestReleaseTag();
        if (latestTag == null) {
            return;
        }
        String currentVersion = this.getPlugin().getDescription().getVersion();
        if (this.githubVersionIsNewer(latestTag, currentVersion)) {
            this.setNewVersionAvailable(true);
            this.setLatestVersion(latestTag);
            this.getLogger().info(this.getNewVersionConsoleMessage(latestTag, currentVersion, this.getLatestVersionUrl()));
        } else {
            this.setNewVersionAvailable(false);
        }
    }

    private String getReleasesApiUrl() {
        return "https://api.github.com/repos/" + this.repoOwner + "/" + this.repoName + "/releases/latest";
    }

    @Override
    public String getLatestVersionUrl() {
        return "https://github.com/" + this.repoOwner + "/" + this.repoName + "/releases/latest";
    }

    private boolean githubVersionIsNewer(String latest, String current) {
        try {
            SemanticVersion latestSem = new SemanticVersion(latest);
            SemanticVersion currentSem = new SemanticVersion(current);
            return latestSem.isGreaterThan(currentSem);
        }
        catch (IllegalArgumentException e) {
            return !latest.trim().equals(current.trim());
        }
    }

    private String fetchLatestReleaseTag() {
        try {
            HttpURLConnection connection = this.createHttpConnection(this.getReleasesApiUrl());
            if (connection.getResponseCode() == 200) {
                String response = this.readResponse(connection);
                JSONObject releaseJson = (JSONObject)new JSONParser().parse(response);
                return (String)releaseJson.get((Object)"tag_name");
            }
            this.getLogger().warning("GitHub API request failed: " + connection.getResponseCode());
        }
        catch (Exception e) {
            this.getLogger().warning("Error fetching GitHub release: " + e.getMessage());
        }
        return null;
    }

    private HttpURLConnection createHttpConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        return connection;
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }
}

