/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.commands;

import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterTabCompleter;
import com.zetaplugins.zetacore.libs.reflections.Reflections;
import com.zetaplugins.zetacore.libs.reflections.scanners.Scanner;
import com.zetaplugins.zetacore.services.commands.CommandRegistrar;
import com.zetaplugins.zetacore.services.commands.RegisterableCommand;
import com.zetaplugins.zetacore.services.di.ManagerRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public class AutoCommandRegistrar
implements CommandRegistrar {
    private final JavaPlugin plugin;
    private final String packagePrefix;
    private final String commandNamespace;
    private final ManagerRegistry managerRegistry;

    public AutoCommandRegistrar(JavaPlugin plugin, String packagePrefix) {
        this.plugin = plugin;
        this.packagePrefix = packagePrefix;
        this.commandNamespace = plugin.getName().toLowerCase();
        this.managerRegistry = null;
    }

    public AutoCommandRegistrar(JavaPlugin plugin, String packagePrefix, String commandNamespace) {
        this.plugin = plugin;
        this.packagePrefix = packagePrefix;
        this.commandNamespace = commandNamespace;
        this.managerRegistry = null;
    }

    public AutoCommandRegistrar(JavaPlugin plugin, String packagePrefix, String commandNamespace, ManagerRegistry managerRegistry) {
        this.plugin = plugin;
        this.packagePrefix = packagePrefix;
        this.commandNamespace = commandNamespace;
        this.managerRegistry = managerRegistry;
    }

    private CommandMap getCommandMap() {
        try {
            Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            return (CommandMap)field.get(Bukkit.getServer());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get command map: " + e.getMessage());
            return null;
        }
    }

    @Override
    public List<String> registerAllCommands() {
        return this.registerAllCommands(name -> true);
    }

    public List<String> registerAllCommands(Predicate<String> commandNameFilter) {
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        ArrayList<String> registeredCommands = new ArrayList<String>();
        HashMap<String, TabCompleter> tabCompleters = new HashMap<String, TabCompleter>();
        Set<Class<?>> tabCompleterClasses = reflections.getTypesAnnotatedWith(AutoRegisterTabCompleter.class);
        for (Class<?> clazz : tabCompleterClasses) {
            ArrayList<String> names;
            TabCompleter completer;
            block12: {
                if (!TabCompleter.class.isAssignableFrom(clazz)) continue;
                AutoRegisterTabCompleter annotation = clazz.getAnnotation(AutoRegisterTabCompleter.class);
                completer = this.createTabCompleter(clazz);
                if (completer == null) continue;
                this.injectManagers(completer);
                names = new ArrayList<String>();
                try {
                    Method commandsMethod = annotation.annotationType().getMethod("commands", new Class[0]);
                    String[] arr = (String[])commandsMethod.invoke((Object)annotation, new Object[0]);
                    if (arr != null && arr.length > 0) {
                        for (String n : arr) {
                            if (n == null || n.isEmpty() || !commandNameFilter.test(n)) continue;
                            names.add(n);
                        }
                        break block12;
                    }
                    throw new NoSuchMethodException();
                }
                catch (NoSuchMethodException ignored) {
                    try {
                        Method commandMethod = annotation.annotationType().getMethod("command", new Class[0]);
                        String n = (String)commandMethod.invoke((Object)annotation, new Object[0]);
                        if (n == null || n.isEmpty() || !commandNameFilter.test(n)) {
                            throw new NoSuchMethodException();
                        }
                        names.add(n);
                    }
                    catch (NoSuchMethodException ignored2) {
                        this.plugin.getLogger().warning("AutoRegisterTabCompleter annotation on " + clazz.getSimpleName() + " has no 'commands' or 'command' method");
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.WARNING, "Failed to read AutoRegisterTabCompleter annotation on " + clazz.getSimpleName(), e);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to read AutoRegisterTabCompleter annotation on " + clazz.getSimpleName(), e);
                }
            }
            for (String name : names) {
                tabCompleters.put(name, completer);
            }
        }
        Set<Class<?>> commandClasses = reflections.getTypesAnnotatedWith(AutoRegisterCommand.class);
        for (Class<?> clazz : commandClasses) {
            List<String> names;
            if (!CommandExecutor.class.isAssignableFrom(clazz) || (names = this.registerCommand(clazz, tabCompleters, commandNameFilter)) == null || names.isEmpty()) continue;
            registeredCommands.addAll(names);
        }
        registeredCommands.sort(String::compareTo);
        return registeredCommands;
    }

    private TabCompleter createTabCompleter(Class<?> completerClass) {
        try {
            try {
                Constructor<?> constructor = completerClass.getConstructor(this.plugin.getClass());
                return (TabCompleter)constructor.newInstance(this.plugin);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constructor = completerClass.getConstructor(new Class[0]);
                return (TabCompleter)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create tab completer: " + completerClass.getSimpleName(), e);
            return null;
        }
    }

    private List<String> registerCommand(Class<?> commandClass, Map<String, TabCompleter> tabCompleters, Predicate<String> commandNameFilter) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            CommandExecutor executor;
            ArrayList<RegisterableCommand> commandsToRegister;
            block16: {
                AutoRegisterCommand annotation = commandClass.getAnnotation(AutoRegisterCommand.class);
                if (annotation == null) {
                    return result;
                }
                commandsToRegister = new ArrayList<RegisterableCommand>();
                try {
                    Method commandsMethod = annotation.annotationType().getMethod("commands", new Class[0]);
                    String[] names = (String[])commandsMethod.invoke((Object)annotation, new Object[0]);
                    if (names != null && names.length > 0) {
                        for (String n : names) {
                            if (n == null || n.isEmpty() || !commandNameFilter.test(n)) continue;
                            commandsToRegister.add(RegisterableCommand.fromAnnotation(n, annotation));
                        }
                        break block16;
                    }
                    throw new NoSuchMethodException();
                }
                catch (NoSuchMethodException ignored) {
                    try {
                        Method commandMethod = annotation.annotationType().getMethod("command", new Class[0]);
                        String name = (String)commandMethod.invoke((Object)annotation, new Object[0]);
                        if (name == null || name.isEmpty() || !commandNameFilter.test(name)) {
                            throw new NoSuchMethodException();
                        }
                        commandsToRegister.add(RegisterableCommand.fromAnnotation(name, annotation));
                    }
                    catch (NoSuchMethodException ignored2) {
                        this.plugin.getLogger().warning("AutoRegisterCommand annotation on " + commandClass.getSimpleName() + " has no 'commands' or 'command' method");
                    }
                }
            }
            if (commandsToRegister.isEmpty()) {
                return result;
            }
            try {
                Constructor<?> constructor = commandClass.getConstructor(this.plugin.getClass());
                executor = (CommandExecutor)constructor.newInstance(this.plugin);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<?> constructor = commandClass.getConstructor(new Class[0]);
                    executor = (CommandExecutor)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    this.plugin.getLogger().severe("No suitable constructor found for command class: " + commandClass.getSimpleName());
                    return null;
                }
            }
            this.injectManagers(executor);
            for (RegisterableCommand registerableCommand : commandsToRegister) {
                TabCompleter tabCompleter;
                TabCompleter tabCompleter2 = tabCompleter = executor instanceof TabCompleter ? (TabCompleter)executor : (TabCompleter)tabCompleters.getOrDefault(registerableCommand.name(), null);
                boolean success = registerableCommand.register(this.plugin, this.commandNamespace, this.getCommandMap(), executor, tabCompleter);
                if (!success) continue;
                result.add(registerableCommand.name());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to register command: " + commandClass.getSimpleName(), e);
        }
        return result;
    }

    @Override
    public void registerCommand(String name, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand command = this.plugin.getCommand(name);
        if (executor == null) {
            this.plugin.getLogger().warning("Cannot register command '" + name + "' with null executor.");
            return;
        }
        if (command == null) {
            this.plugin.getLogger().warning("Command '" + name + "' not found in plugin.yml.");
            return;
        }
        this.injectManagers(executor);
        command.setExecutor(executor);
        if (tabCompleter != null) {
            this.injectManagers(tabCompleter);
            command.setTabCompleter(tabCompleter);
        } else if (executor instanceof TabCompleter) {
            TabCompleter tabComp = (TabCompleter)executor;
            this.injectManagers(tabComp);
            command.setTabCompleter(tabComp);
        }
    }

    private void injectManagers(Object target) {
        if (this.managerRegistry != null) {
            this.managerRegistry.injectManagers(target);
        }
    }

    public static class Builder {
        private JavaPlugin plugin;
        private String packagePrefix;
        private String commandNamespace;
        private ManagerRegistry managerRegistry;

        public Builder setPlugin(JavaPlugin plugin) {
            this.plugin = plugin;
            return this;
        }

        public Builder setPackagePrefix(String packagePrefix) {
            this.packagePrefix = packagePrefix;
            return this;
        }

        public Builder setCommandNamespace(String commandNamespace) {
            this.commandNamespace = commandNamespace;
            return this;
        }

        public Builder setManagerRegistry(ManagerRegistry managerRegistry) {
            this.managerRegistry = managerRegistry;
            return this;
        }

        public AutoCommandRegistrar build() {
            if (this.plugin == null) {
                throw new IllegalStateException("Plugin must be set");
            }
            if (this.packagePrefix == null) {
                throw new IllegalStateException("Package prefix must be set");
            }
            if (this.commandNamespace == null) {
                this.commandNamespace = this.plugin.getName().toLowerCase();
            }
            return new AutoCommandRegistrar(this.plugin, this.packagePrefix, this.commandNamespace, this.managerRegistry);
        }
    }
}

