/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.commands;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class CommandUtils {
    private CommandUtils() {
    }

    public static List<String> getDisplayOptions(Collection<String> options, String input) {
        return options.stream().filter(option -> CommandUtils.startsWithIgnoreCase(option, input)).collect(Collectors.toList());
    }

    public static List<String> getPlayerOptions(JavaPlugin plugin, String input) {
        return CommandUtils.getDisplayOptions(plugin.getServer().getOnlinePlayers().parallelStream().map(Player::getName).collect(Collectors.toList()), input);
    }

    private static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

