/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.util;

import com.zetaplugins.essentialz.EssentialZ;
import java.util.Objects;

public enum MessageStyle {
    NONE("none"),
    DEFAULT("default"),
    ERROR("error"),
    WARNING("warning"),
    SUCCESS("success"),
    MOVEMENT("movement"),
    COMBAT("combat"),
    MODERATION("moderation"),
    ITEMS("items"),
    STATS("stats"),
    COMMUNICATION("communication"),
    TEAMCHAT("teamchat"),
    WORLDCONTROL("worldcontrol"),
    ECONOMY("economy");

    public final String id;

    private MessageStyle(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getAccentColor(EssentialZ plugin) {
        if (Objects.equals(this.getId(), "none")) {
            return "#ba7cf8";
        }
        String accentColor = plugin.getConfig().getString("styles." + this.getId() + ".accentColor");
        return accentColor == null ? "#ba7cf8" : accentColor;
    }

    public String getPrefix(EssentialZ plugin) {
        if (Objects.equals(this.getId(), "none")) {
            return "";
        }
        String prefix = plugin.getConfig().getString("styles." + this.getId() + ".prefix");
        return prefix == null ? "&8[<gradient:#ba7cf8:#ba7cf8>EssentialZ&8]" : prefix;
    }

    public static MessageStyle of(String id) {
        for (MessageStyle style : MessageStyle.values()) {
            if (!style.id.equals(id)) continue;
            return style;
        }
        return null;
    }
}

