/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.movement;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBeOrSpecifyPlayerException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"fly"}, description="Allow players to fly.", usage="/fly <player>", permission="essentialz.fly")
public class FlyCommand
extends EszCommand {
    public FlyCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandPermissionException, CommandSenderMustBeOrSpecifyPlayerException {
        Player player;
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        if (!(targetPlayer == null || sender instanceof Player && (player = (Player)sender).getUniqueId().equals(targetPlayer.getUniqueId()))) {
            if (!Permission.FLY_OTHERS.has((Permissible)sender)) {
                throw new CommandPermissionException(Permission.FLY_OTHERS.getNode());
            }
            targetPlayer.setAllowFlight(!targetPlayer.getAllowFlight());
            this.sendOthersConfirmationMessage(targetPlayer, sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBeOrSpecifyPlayerException();
        }
        player = (Player)sender;
        player.setAllowFlight(!player.getAllowFlight());
        this.sendSelfConfirmationMessage(player);
        return true;
    }

    public void sendSelfConfirmationMessage(Player player) {
        if (player.getAllowFlight()) {
            player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ALLOWED_TO_FLY, new MessageManager.Replaceable[0]));
        } else {
            player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.NOT_ALLOWED_TO_FLY, new MessageManager.Replaceable[0]));
        }
    }

    public void sendOthersConfirmationMessage(Player targetPlayer, CommandSender sender) {
        this.sendSelfConfirmationMessage(targetPlayer);
        if (targetPlayer.getAllowFlight()) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ALLOWED_TO_FLY_OTHER, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
        } else {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.NOT_ALLOWED_TO_FLY_OTHER, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 && Permission.FLY_OTHERS.has((Permissible)sender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

