/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.GiveMaterialManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.MessageStyle;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"give"}, description="Gives a player a specified item.", usage="/give [player] <item> [amount]", permission="essentialz.give")
public class GiveCommand
extends EszCommand {
    @InjectManager
    private GiveMaterialManager giveMaterialManager;

    public GiveCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandUsageException {
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        if (targetPlayer == null) {
            throw new CommandUsageException("/give [player] <item> [amount]");
        }
        String materialName = args.getArg(1);
        if (materialName == null) {
            throw new CommandUsageException("/give [player] <item> [amount]");
        }
        Material material = this.giveMaterialManager.getMaterialByKey(materialName);
        if (material == null) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ERROR, "invalidMaterial", "{ac}'{material}' is not a valid material.", new MessageManager.Replaceable<String>("{material}", materialName)));
            return false;
        }
        int amount = args.getInt(2, 1);
        ItemStack itemStack = new ItemStack(material, amount);
        targetPlayer.getInventory().addItem(new ItemStack[]{itemStack});
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ITEMS, "giveConfirmation", "&7Gave {ac}{amount}x {material}&7 to {ac}{player}&7.", new MessageManager.Replaceable<String>("{amount}", String.valueOf(amount)), new MessageManager.Replaceable<String>("{material}", material.name()), new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1) {
            return this.getDisplayOptions(this.giveMaterialManager.getPossibleMaterials(), args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 2) {
            return this.getDisplayOptions(List.of("1", "16", "32", "64"), args.getCurrentArg());
        }
        return List.of();
    }
}

