/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBeOrSpecifyPlayerException;
import java.util.List;
import java.util.Objects;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"heal"}, description="Heal a player to full health", usage="/heal [player]", permission="essentialz.heal")
public class HealCommand
extends EszCommand {
    public HealCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandException, CommandSenderMustBeOrSpecifyPlayerException {
        boolean isSelfHeal;
        Player targetPlayer = args.getPlayer(0, sender instanceof Player ? (Player)sender : null, (JavaPlugin)this.getPlugin());
        if (targetPlayer == null) {
            throw new CommandSenderMustBeOrSpecifyPlayerException();
        }
        boolean bl = isSelfHeal = sender instanceof Player && ((Player)sender).getUniqueId().equals(targetPlayer.getUniqueId());
        if (!isSelfHeal && !Permission.HEAL_OTHERS.has((Permissible)sender)) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.NO_PERMISSION_HEAL_OTHERS, new MessageManager.Replaceable[0]));
            return false;
        }
        double maxHealth = targetPlayer.getAttribute(Attribute.GENERIC_MAX_HEALTH) != null ? Objects.requireNonNull(targetPlayer.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getDefaultValue() : 20.0;
        targetPlayer.setHealth(maxHealth);
        if (isSelfHeal) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.HEAL_SELF, new MessageManager.Replaceable[0]));
        } else {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.HEAL_OTHER, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 && Permission.HEAL_OTHERS.has((Permissible)sender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

