/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.events;

import com.zetaplugins.zetacore.annotations.AutoRegisterListener;
import com.zetaplugins.zetacore.libs.reflections.Reflections;
import com.zetaplugins.zetacore.libs.reflections.scanners.Scanner;
import com.zetaplugins.zetacore.services.di.ManagerRegistry;
import com.zetaplugins.zetacore.services.events.EventRegistrar;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AutoEventRegistrar
implements EventRegistrar {
    private final JavaPlugin plugin;
    private final String packagePrefix;
    private final ManagerRegistry managerRegistry;

    public AutoEventRegistrar(JavaPlugin plugin, String packagePrefix) {
        this.plugin = plugin;
        this.packagePrefix = packagePrefix;
        this.managerRegistry = null;
    }

    public AutoEventRegistrar(JavaPlugin plugin, String packagePrefix, ManagerRegistry managerRegistry) {
        this.plugin = plugin;
        this.packagePrefix = packagePrefix;
        this.managerRegistry = managerRegistry;
    }

    @Override
    public List<String> registerAllListeners() {
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegisterListener.class);
        ArrayList<String> registeredListeners = new ArrayList<String>();
        for (Class<?> clazz : annotatedClasses) {
            String listenerName;
            if (!Listener.class.isAssignableFrom(clazz) || (listenerName = this.registerListener(clazz)) == null) continue;
            registeredListeners.add(listenerName);
        }
        registeredListeners.sort(String::compareTo);
        return registeredListeners;
    }

    private String registerListener(Class<?> listenerClass) {
        try {
            Listener listener;
            try {
                Constructor<?> constructor = listenerClass.getConstructor(this.plugin.getClass());
                listener = (Listener)constructor.newInstance(this.plugin);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<?> constructor = listenerClass.getConstructor(new Class[0]);
                    listener = (Listener)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    this.plugin.getLogger().severe("No suitable constructor found for listener: " + listenerClass.getSimpleName());
                    return null;
                }
            }
            if (this.managerRegistry != null) {
                this.managerRegistry.injectManagers(listener);
            }
            this.plugin.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
            AutoRegisterListener annotation = listenerClass.getAnnotation(AutoRegisterListener.class);
            return annotation.name().isEmpty() ? listenerClass.getSimpleName() : annotation.name();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to register listener: " + listenerClass.getSimpleName(), e);
            return null;
        }
    }

    @Override
    public void registerListener(Listener ... listener) {
        for (Listener l : listener) {
            if (l == null) continue;
            if (this.managerRegistry != null) {
                this.managerRegistry.injectManagers(l);
            }
            this.plugin.getServer().getPluginManager().registerEvents(l, (Plugin)this.plugin);
        }
    }

    public static class Builder {
        private JavaPlugin plugin;
        private String packagePrefix;
        private ManagerRegistry managerRegistry;

        public Builder setPlugin(JavaPlugin plugin) {
            this.plugin = plugin;
            return this;
        }

        public Builder setPackagePrefix(String packagePrefix) {
            this.packagePrefix = packagePrefix;
            return this;
        }

        public Builder setManagerRegistry(ManagerRegistry managerRegistry) {
            this.managerRegistry = managerRegistry;
            return this;
        }

        public AutoEventRegistrar build() {
            if (this.plugin == null) {
                throw new IllegalStateException("Plugin must be set");
            }
            if (this.packagePrefix == null) {
                throw new IllegalStateException("Package prefix must be set");
            }
            return new AutoEventRegistrar(this.plugin, this.packagePrefix, this.managerRegistry);
        }
    }
}

