/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.util;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.LanguageManager;
import com.zetaplugins.essentialz.util.MessageStyle;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.Manager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@Manager
public class MessageManager {
    private final EssentialZ plugin;
    private final Map<String, String> colorMap;
    @InjectManager
    private LanguageManager languageManager;

    public MessageManager(EssentialZ plugin) {
        this.plugin = plugin;
        this.colorMap = new HashMap<String, String>();
        this.colorMap.put("&0", "<black>");
        this.colorMap.put("&1", "<dark_blue>");
        this.colorMap.put("&2", "<dark_green>");
        this.colorMap.put("&3", "<dark_aqua>");
        this.colorMap.put("&4", "<dark_red>");
        this.colorMap.put("&5", "<dark_purple>");
        this.colorMap.put("&6", "<gold>");
        this.colorMap.put("&7", "<gray>");
        this.colorMap.put("&8", "<dark_gray>");
        this.colorMap.put("&9", "<blue>");
        this.colorMap.put("&a", "<green>");
        this.colorMap.put("&b", "<aqua>");
        this.colorMap.put("&c", "<red>");
        this.colorMap.put("&d", "<light_purple>");
        this.colorMap.put("&e", "<yellow>");
        this.colorMap.put("&f", "<white>");
        this.colorMap.put("&k", "<obfuscated>");
        this.colorMap.put("&l", "<bold>");
        this.colorMap.put("&m", "<strikethrough>");
        this.colorMap.put("&n", "<underline>");
        this.colorMap.put("&o", "<italic>");
        this.colorMap.put("&r", "<reset>");
    }

    public Component formatMsg(String msg, Replaceable<?> ... replaceables) {
        MiniMessage mm = MiniMessage.miniMessage();
        msg = this.replaceColorCodes(msg);
        ResolverResult result = this.buildResolvers(mm, msg, MessageStyle.NONE, replaceables);
        return mm.deserialize("<!i>" + result.msg(), result.resolvers());
    }

    public Component getAndFormatMsg(MessageStyle style, String path, String fallback, Replaceable<?> ... replaceables) {
        return this.getAndFormatMsg(style, path, fallback, true, replaceables);
    }

    public Component getAndFormatMsg(MessageStyle style, String path, String fallback, boolean addPrefix, Replaceable<?> ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        MiniMessage mm = MiniMessage.miniMessage();
        Object msg = this.languageManager.getString(path, fallback);
        msg = ((String)msg).replaceAll("\\{style\\.[^}]+}", "");
        if (addPrefix) {
            msg = style.getPrefix(this.plugin) + (String)msg;
        }
        msg = ((String)msg).replace("{prefix}", style.getPrefix(this.plugin));
        msg = this.replaceColorCodes((String)msg, style);
        ResolverResult result = this.buildResolvers(mm, (String)msg, style, replaceables);
        return mm.deserialize("<!i>" + result.msg(), result.resolvers());
    }

    public Component getAndFormatMsg(PluginMessage message, Replaceable<?> ... replaceables) {
        return this.getAndFormatMsg(message, true, replaceables);
    }

    public Component getAndFormatMsg(PluginMessage pluginMessage, boolean addPrefix, Replaceable<?> ... replaceables) {
        return this.getAndFormatMsg(pluginMessage.getStyle(this.languageManager), pluginMessage.getKey(), pluginMessage.getDefaultMessage(), addPrefix, replaceables);
    }

    private ResolverResult buildResolvers(MiniMessage mm, String msg, MessageStyle valueStyle, Replaceable<?> ... replaceables) {
        ArrayList<TagResolver.Single> resolvers = new ArrayList<TagResolver.Single>();
        MessageStyle replacementStyle = valueStyle == null ? MessageStyle.NONE : valueStyle;
        for (Replaceable<?> r : replaceables) {
            Component replacementComponent;
            String rawName = r.placeholder().replaceAll("^\\{?|\\}?$", "");
            String tagName = rawName.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_-]", "_");
            String tagToken = "<" + tagName + ">";
            msg = msg.replace(r.placeholder(), tagToken);
            Object obj = r.value();
            if (obj instanceof Component) {
                Component component;
                replacementComponent = component = (Component)obj;
            } else {
                String valueStr = Objects.toString(r.value());
                replacementComponent = r.deserialize() ? mm.deserialize((Object)this.replaceColorCodes(valueStr, replacementStyle)) : Component.text((String)valueStr);
            }
            resolvers.add(TagResolver.resolver((String)tagName, (Tag)Tag.inserting((Component)replacementComponent)));
        }
        return new ResolverResult(msg, (TagResolver[])resolvers.toArray(TagResolver[]::new));
    }

    private String replaceColorCodes(String msg) {
        return this.replaceColorCodes(msg, MessageStyle.NONE);
    }

    private String replaceColorCodes(String msg, MessageStyle style) {
        msg = msg.replace("{ac}", "<" + style.getAccentColor(this.plugin) + ">");
        for (MessageStyle currentStyle : MessageStyle.values()) {
            String styleAccentColor = currentStyle.getAccentColor(this.plugin);
            msg = msg.replace("{ac_" + currentStyle.getId() + "}", "<" + styleAccentColor + ">");
        }
        for (Map.Entry entry : this.colorMap.entrySet()) {
            msg = msg.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return msg;
    }

    public record Replaceable<T>(String placeholder, T value, boolean deserialize) {
        public Replaceable(String placeholder, T value) {
            this(placeholder, value, false);
        }
    }

    private record ResolverResult(String msg, TagResolver[] resolvers) {
    }
}

